package jp.turbosql.modules.at.app.wizards;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.accessibility.*;
import javax.swing.text.html.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

public class WizardControllerPane extends JComponent implements Accessible
{
    protected JDialog dialog;
    protected Dimension screenSize;
    protected JPanel wizardPanel;
    protected JPanel wizardletPanel;
    protected JScrollPane wizardletScrollPane;
    protected JEditorPane stepEditorPane;
    protected JScrollPane stepScrollPane;
    protected JPanel buttonPanel;
    
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton finishButton;
    protected JButton cancelButton;
    protected JButton helpButton;
    
    protected JFrame parentFrame;
    
    protected Wizardlet[] wizardlets;
    protected int currentStep = 0;
    
    protected boolean normalFinish = false;
        
    public WizardControllerPane(Wizardlet[] wizardlets)
    {
        // we hold the actual reference to the wizardlets, so does the calling method
        this.wizardlets = wizardlets;
        
        wizardPanel = new JPanel();
        wizardletPanel = new JPanel();
        wizardletScrollPane = new JScrollPane();
        stepEditorPane = new JEditorPane();
        
        stepEditorPane.setEditorKit(new HTMLEditorKit());
        stepEditorPane.setEditable(false);
        stepEditorPane.setBackground(new Color(255, 204, 153));
        
        stepScrollPane = new JScrollPane(stepEditorPane);
        buttonPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        
        backButton = new JButton("<Back");
        backButton.addActionListener(new AbstractAction("<Back"){
            public void actionPerformed(ActionEvent e)
            {
                navigateBack();
            } // public void actionPerformed(ActionEvent e)
        });
        
        nextButton = new JButton("Next>");
        nextButton.addActionListener(new AbstractAction("Next>"){
            public void actionPerformed(ActionEvent e)
            {
                navigateNext();
            } // public void actionPerformed(ActionEvent e)
        });
        
        finishButton = new JButton("Finish");
        finishButton.addActionListener(new AbstractAction("Finish"){
            public void actionPerformed(ActionEvent e)
            {
                navigateFinish();
            } // public void actionPerformed(ActionEvent e)
        });
        
        cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction("Cancel"){
            public void actionPerformed(ActionEvent e)
            {
                navigateCancel();
            } // public void actionPerformed(ActionEvent e)
        });
        
        helpButton = new JButton("Help");
        helpButton.addActionListener(new AbstractAction("Help"){
            public void actionPerformed(ActionEvent e)
            {
                navigateHelp();
            } // public void actionPerformed(ActionEvent e)
        });
        
        buttonPanel.add(backButton);
        buttonPanel.add(nextButton);
        buttonPanel.add(finishButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(helpButton);
        
        buttonPanel.setAlignmentX(JPanel.RIGHT_ALIGNMENT);
        
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        wizardPanel.setLayout(new BorderLayout());
        wizardPanel.add(buttonPanel, BorderLayout.SOUTH);
                
        //JPanel centeringPanel = new JPanel(new BorderLayout());
        //centeringPanel.add(wizardletScrollPane, BorderLayout.CENTER);
        
        //((ScrollPaneLayout) wizardletScrollPane.getLayout())
        
        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                                              true,                     // Continuous relayout
                                              stepScrollPane,                 // Left pane content
                                              wizardletScrollPane);               // Right pane content
        wizardPanel.add(splitPane, BorderLayout.CENTER);
        splitPane.setDividerLocation(180);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setDividerSize(3);
        
        //wizardletScrollPane.setViewportView(wizardlets[0]);
        
        processCurrentStep(0);      // we can set it to the first wizardlet, since there has to be at least one wizalet
    } // public WizardControllerPane(Wizardlet[] wizardlets)
    
    public JDialog createDialog(Component parentComponent, String title)
    {
        int width = 630, height = 460;
        dialog = new JDialog((JFrame)parentComponent, true);
        parentFrame = (JFrame)parentComponent;
        dialog.setTitle(title);
        Container contentPane = dialog.getContentPane();
        contentPane.add(wizardPanel);
        
        /*
        //contentPanel.setBounds(new Rectangle(new Dimension(width, height + extraHeight)));
        okButton.addActionListener(new AbstractAction("Ok"){
            public void actionPerformed(ActionEvent e)
            {
                if(performOKAction() == 0)
                    if(refreshListener != null)
                        refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
                
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        
        contentPane.add(contentPanel);
        cancelButton.addActionListener(new AbstractAction("Cancel"){
            public void actionPerformed(ActionEvent e)
            {
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        */
        dialog.setBounds((screenSize.width - width)/2, (screenSize.height - height)/2, width, height);
               
        return dialog;
    } // public JDialog createDialog(Component parentComponent, String title)
    
    public void processCurrentStep(int step)
    {
        backButton.setEnabled(true);
        nextButton.setEnabled(true);
        //finishButton.setEnabled(true);
        //cancelButton.setEnabled(true);
        helpButton.setEnabled(false);
        
        if(step == 0)
        {
            backButton.setEnabled(false);            
        } // if(step == 0)
        if (step == (wizardlets.length - 1))
        {
            nextButton.setEnabled(false);
        } // else if (step == (wizardlets.length - 1))        
        if(wizardlets[step].hasHelpMenu())
        {
            helpButton.setEnabled(true);
        } // if(wizardlets[step].hasHelpMenu)
        
        stepEditorPane.setText(getCurrentStepHTML(step));
        wizardletScrollPane.setViewportView(wizardlets[step]);
        
        currentStep = step;
    } // public void processCurrentStep(int step)
    
    public String getCurrentStepHTML(int step)
    {
        String htmlStr = "Steps:<HR>";
               
        for(int i = 0; i < wizardlets.length; i++)
        {
            if(i == step)
                htmlStr = htmlStr + "<B>" + (i + 1) + ". " + wizardlets[i].getStepName() + "</B><BR>";
            else
                htmlStr = htmlStr + + (i + 1) + ". " + wizardlets[i].getStepName() + "<BR>";
        } // for(int i = 0; i < wizardlets.length; i++)
        
        return htmlStr;
    } // public String getCurrentStepHTML(int step)
        
    public void navigateBack()
    {
        processCurrentStep(currentStep - 1);        
    } // public int navigateBack()
    
    public void navigateNext()
    {
        processCurrentStep(currentStep + 1);        
    } // public int navigateNext()
    
    public void navigateFinish()
    {
        normalFinish = true;
        dialog.dispose();
    } // public int navigateFinish()
    
    public void navigateCancel()
    {
        dialog.dispose();
    } // public int navigateCancel()
    
    // to be added next time
    public void navigateHelp()
    {
        wizardlets[currentStep].getHelpMenu((Component) parentFrame).show();
    } // public int navigateHelp()
    
    // this indicates that the finish was clicked
    public boolean getNormalFinish()
    {
        return normalFinish;
    } // public boolean getNormalFinish()
            
    public static void main(String[] args)
    {
        JFrame frame = new JFrame();
        frame.setBounds(0, 0, 100, 100);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(frame.DISPOSE_ON_CLOSE);
        String[] properties = {"appBase", "className", "name"};
        String[] properties2 = {"name", "surfix", "postfix"};
        String[] properties3 = {"big", "small", "left", "right"};
        Wizardlet[] wizardlets = {new GenericWizardlet(properties, null, true), new GenericWizardlet(properties2, null, true), new GenericWizardlet(properties3, null, true)};
                
        WizardControllerPane controllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = controllerPane.createDialog(frame, "Wizard");
        dialog.show();
    } // public static void main(String[] args)
} // public class WizardControllerPane extends JComponent implements Accessible