package backup.app;

import java.util.Vector;
import java.lang.NumberFormatException;

public class OriginalRowsContainer
{
    Vector originalRows;
    Vector changedRows;
    Vector changedRowsIndex;
    
    public OriginalRowsContainer()
    {
        originalRows = new Vector();
        changedRowsIndex = new Vector();
        changedRows = new Vector();
    } // public OriginalRowContainer()
    
    public void add(int param_row, Object[] param_originalRowData, Object[] param_changedRowData)
    {
        if(!changedRowsIndex.contains(Integer.toString(param_row)))
        {
            originalRows.add(new RowBean(param_row, param_originalRowData));
            changedRows.add(new RowBean(param_row, param_changedRowData));
            changedRowsIndex.add(Integer.toString(param_row));
        } // if(!changedRowsIndex.contains(param_row))
        else
        {
            int rowIndex = changedRowsIndex.indexOf(Integer.toString(param_row));
            changedRows.remove(rowIndex);
            changedRows.insertElementAt(new RowBean(param_row, param_changedRowData), rowIndex);
        } // else
    } // public void add(int param_row, Object[] param_rowData)
    
    public void remove(int param_row)
    {
        if(changedRowsIndex.contains(Integer.toString(param_row)))
        {
            int rowIndex = changedRowsIndex.indexOf(Integer.toString(param_row));
            originalRows.remove(rowIndex);
            changedRows.remove(rowIndex);
            changedRowsIndex.remove(rowIndex);
        } // if(!changedRowsIndex.contains(param_row))
    } // public void remove(int param_row)
    
    public void removeAllElements()
    {
        originalRows.removeAllElements();
        changedRows.removeAllElements();
        changedRowsIndex.removeAllElements();
    } // public void removeAll()
    
    // Index of the rows whose data has changed
    public int[] getChangedRowsIndexArray()
    {
        int[] arr = new int[changedRowsIndex.size()];
        try
        {
            for(int i = 0; i < changedRowsIndex.size(); i++)        
                arr[i] = Integer.parseInt(changedRowsIndex.elementAt(i).toString());
        } // try
        catch(NumberFormatException nfe)
        {
            System.out.println(nfe.toString());
            return null;
        }
        return arr;
    } // public int[] getChangedRowIndexArray()
    
    public Object[] getOriginalRowsAllArray()
    {
        Object[] arr = new Object[originalRows.size()];
        for(int i = 0; i < originalRows.size(); i++)        
            arr[i] = originalRows.elementAt(i);
        return arr;
    } // public Object[] getOriginalRowsArray()
    
    public Object[] getChangedRowsAllArray()
    {
        Object[] arr = new Object[changedRows.size()];
        for(int i = 0; i < changedRows.size(); i++)        
            arr[i] = changedRows.elementAt(i);
        return arr;
    } // public Object[] getChangedRowsArray()
    
    public int getChangedRowsCount()
    {
        return changedRows.size();
    } // public int getChangedRowsCount()
    
} // public class OriginalRowContainer
