import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.event.*;

class FontDialog extends JDialog implements Constants, ActionListener, ListSelectionListener
{
    private SketchFrame2 window;
    private Font font;
    private int fontStyle;
    private int fontSize;
    
    private JButton ok;
    private JButton cancel;
    
    private JList fontList;
    
    private JComboBox chooseSize;
    private JLabel fontDisplay;
    
    public FontDialog(SketchFrame2 window)
    {
        super(window, "Font Selection", true);
        
        this.window = window;
        font = window.getCurrentFont();
        fontStyle = font.getStyle();
        fontSize = font.getSize();
        
        JPanel buttonPane = new JPanel();
        
        buttonPane.add(ok = createButton("OK"));
        buttonPane.add(cancel = createButton("Cancel"));
        getContentPane().add(buttonPane, BorderLayout.SOUTH);
        
        JPanel dataPane = new JPanel();
        dataPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gbLayout = new GridBagLayout();
        dataPane.setLayout(gbLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        
        JLabel label = new JLabel("Choose a Font");
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        gbLayout.setConstraints(label, constraints);
        dataPane.add(label);
        
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = e.getAvailableFontFamilyNames();
        
        fontList = new JList(fontNames);
        fontList.setValueIsAdjusting(true);
        fontList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        fontList.setSelectedValue(font.getFamily(), true);
        fontList.addListSelectionListener(this);
        JScrollPane chooseFont = new JScrollPane(fontList);
        chooseFont.setMinimumSize(new Dimension(300, 100));
        
        JPanel display = new JPanel();
        fontDisplay = new JLabel("Sample Size: x X y Y z Z");
        fontDisplay.setPreferredSize(new Dimension(300, 100));
        display.add(fontDisplay);
        
        JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true, chooseFont, display);
        gbLayout.setConstraints(splitPane, constraints);
        dataPane.add(splitPane);
        
        JPanel sizePane = new JPanel();
        label = new JLabel("Choose point size");
        sizePane.add(label);
        String[] sizeList = {"8", "10", "12", "14", "16", "18", "20", "22", "24"};
        chooseSize = new JComboBox(sizeList);
        chooseSize.setSelectedItem(Integer.toString(fontSize));
        chooseSize.addActionListener(this);
        sizePane.add(chooseSize);
        gbLayout.setConstraints(sizePane, constraints);
        dataPane.add(sizePane);
        
        JRadioButton bold = new JRadioButton("Bold", (fontStyle & Font.BOLD) > 0);
        JRadioButton italic = new JRadioButton("Italic", (fontStyle & Font.ITALIC) > 0);
        bold.addItemListener(new StyleListener(Font.BOLD));
        italic.addItemListener(new StyleListener(Font.ITALIC));
        JPanel stylePane = new JPanel();
        stylePane.add(bold);
        stylePane.add(italic);
        gbLayout.setConstraints(stylePane, constraints);
        dataPane.add(stylePane);
        
        getContentPane().add(dataPane, BorderLayout.CENTER);
        pack();
        setVisible(false);
    } // public FontDialog(SketchFrame window)
        
    JButton createButton(String label)
    {
        JButton button = new JButton(label);
        button.setPreferredSize(new Dimension(80, 20));
        button.addActionListener(this);
        return button;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent e) {
        Object source = e.getSource();
        if(source == ok)
        {
            window.setCurrentFont(font);
            setVisible(false);
        } // if(source == ok)
        else if(source == cancel)
            setVisible(false);
        else if(source == chooseSize)
        {
            fontSize = Integer.parseInt((String) chooseSize.getSelectedItem());
            font = font.deriveFont((float) fontSize);
            fontDisplay.setFont(font);
            fontDisplay.repaint();
        } // else if(source == chooseSize)
    }
    
    public void valueChanged(javax.swing.event.ListSelectionEvent e) {
        if(!e.getValueIsAdjusting())
        {
            font = new Font((String) fontList.getSelectedValue(), fontStyle, fontSize);
            fontDisplay.setFont(font);
            fontDisplay.repaint();
        } // if(!e.getValueIsAdjusting())
    }
    
 // JButton createButton(String label)
    
    class StyleListener implements ItemListener
    {
        private int style;
        
        public StyleListener(int style)
        {
            this.style = style;
        } // public StyleListener(int style)
        
        public void itemStateChanged(java.awt.event.ItemEvent e) {
            if(e.getStateChange() == ItemEvent.SELECTED)
                fontStyle |= style;
            else
                fontStyle &= ~style;
            font = font.deriveFont(fontStyle);
            fontDisplay.setFont(font);
            fontDisplay.repaint();
        }
              
    } // class StyleListener implements ItemListener
} // class FontDialog extends JDialog implements
