import org.apache.xerces.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import java.io.*;

public class DOMParserMaker {

  public static void main(String[] args) {

    // This is simpler but less flexible than the SAX approach.
    // Perhaps a good creational design pattern is needed here?

    String[] args2 = {"/root/java/xml/server.xml"};
      
    DOMParser parser = new DOMParser();

    for (int i = 0; i < args2.length; i++) {
      try {
        // Read the entire document into memory
        parser.parse(args2[i]);

        Document d = parser.getDocument();
        // work with the document...
        Element element = d.getDocumentElement();
        processChild(element);
        /*
        System.out.println(element.getNodeName());
        NodeList child_nodes = element.getChildNodes();
        //System.out.println(child_element.getNodeName());
        //System.out.println(child_element.getNodeValue());
        for(int j = 0; j < child_nodes.getLength(); j++)
        {
            Node temp_node = child_nodes.item(j);
            if(temp_node.hasChildNodes())
            {
                NodeList temp_child_nodes = element.getChildNodes();
                
            } // if(temp_node.hasChildNodes)
            System.out.println(temp_node.getNodeName());
        } // for(int i = 0; i < child_nodes.getLength(); i++)
        */
      }
      catch (SAXException e) {
        System.err.println(e);
      }
      catch (IOException e) {
        System.err.println(e);
      }

    }

  }
  
  public static void processChild(Node param_node)
  {
    if(param_node.hasChildNodes())
    {
        NodeList child_nodes = param_node.getChildNodes();
        for(int i = 0; i < child_nodes.getLength(); i++)
        {
            Node temp_node = child_nodes.item(i);
            System.out.println(temp_node.getNodeName());
            if(temp_node.getNodeValue() != null)
                System.out.println(temp_node.getNodeValue());
            processChild(temp_node);   
        } // for(int i = 0; i < child_nodes.getLength(); i++)
    } // if(param_node.hasChildNodes())
    return;
  } // public void processChild(Node node)
  
}