/*
 * Copyright (c) 2002 Sosnoski Software Solutions, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

import java.io.*;

import javax.xml.parsers.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * Test driver class. Just creates a parser and parses the sample document,
 * then prints stock summary information at the end.
 *
 * @author Dennis M. Sosnoski
 * @version 1.0
 */

public class TestDriver
{
	/**
	 * Main method to run test.
	 */
        private static String absolutePath = "/root/java/xml2/";
	
	public static void main(String[] argv) {
		
		// set up JAXP parser creation
		SAXParserFactory spf = SAXParserFactory.newInstance();
		spf.setValidating(false);
		spf.setNamespaceAware(true);
		try {
			
			// parse the document
			SAXParser parser = spf.newSAXParser();
			DefaultHandler handler = new StockStreamHandler();
			InputSource source = new InputSource
				(new FileReader(new File("/root/java/xml2/trades.xml")));
			parser.parse(source, handler);
			
			// report information from document
			System.out.println("Completed parse");
			StockTrack track = StockTrack.getTrack("SUNW");
			System.out.println(" SUNW traded " + track.getShareVolume() +
				" shares at prices ranging from " + track.getLowPrice() +
				" to " + track.getHighPrice());
			track = StockTrack.getTrack("MSFT");
			System.out.println(" MSFT traded " + track.getShareVolume() +
				" shares at prices ranging from " + track.getLowPrice() +
				" to " + track.getHighPrice());
				
		} catch (Exception ex) {
			ex.printStackTrace(System.err);
			System.exit(0);
		}
	}
}
