package jp.turbosql.modules.db.app.dialogs;

import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

class RelationalTableColumnModel extends AbstractTableModel
{
    Vector dataRows;
    // should be re-factored.
    String[] columnNames;
    Object[] columnTypeArray;
    
    boolean dataChanged = false;
    
    public RelationalTableColumnModel()
    {
        super();
        dataRows = new Vector();
        columnNames = RelationalTableColumnRowDataObject.getColumnNames();
        columnTypeArray = RelationalTableColumnRowDataObject.getColumnTypeArray();
        
        for(int i = 0; i < 256; i++)
        {
            dataRows.add(new RelationalTableColumnRowDataObject());
        } // for(int i = 0; i < 256; i++)
            
    } // public RelationalTableColumnModel()
    
    /*
    public void setResultSet(ResultSet results)
    {
        dataChanged = false;
        originalRows = null;
        if(results == null)
        {
            columnNames = new String[0];                // Reset the columns names
            dataRows.clear();                           // Remove all entries in the Vector
            fireTableChanged(null);                     // Tell the table there is new model data
            return;
        } // if(results == null)
        
        // Make the data in the resultset available through the TabelModel interface...
        try
        {  
            ResultSetMetaData metadata = results.getMetaData();
                    
            int columns = metadata.getColumnCount();         // Get number of columns
            columnCount = columns;
            tableName = metadata.getTableName(columns + 1);
            System.out.println(tableName);
            columnNames = new String[columns];                      // Array to hold names
            columnTypes = new int[columns];
            columnTypeNames = new String[columns];
            tableName = metadata.getTableName(1);
            // Get the column names
            // Added support for determining type
            for(int i = 0; i < columns; i++)
            {
                columnNames[i] = metadata.getColumnLabel(i + 1);
                columnTypes[i] = metadata.getColumnType(i + 1);
                columnTypeNames[i] = metadata.getColumnTypeName(i + 1);
                //System.out.println("column " + (i+1) +": " + metadata.getColumnTypeName(i+1));
            } // for(int i = 0; i < columns; i++)
            dataRows = PostgreSQLDataObject.processToDataRows(results);
            columnTypeArray = PostgreSQLDataObject.processToColumnTypeArray(columnTypes, columnTypeNames);
            
            // added rows processing
            originalRowsCount = dataRows.size();
            //addedRowsCount = 0 ;
            
            fireTableChanged(null);                                 // Signal the table there is new model data
        } // try
        catch (SQLException sqle)
        {
            System.err.println(sqle);
        } // catch (SQLException sqle)
    } // public void setResultSet(ResultSet results)
     */
            
    public int getColumnCount() {
        // Return number of columns...
        return columnNames.length;
    }
    
    public int getRowCount() {
        // Return number of rows...
        if(dataRows == null)
            return 0;
        else
            return dataRows.size();
    }
    
    public Object getValueAt(int row, int column) {
        RelationalTableColumnRowDataObject relationalTableColumnRowDataObject = (RelationalTableColumnRowDataObject) dataRows.get(row);
        
        return relationalTableColumnRowDataObject.getValueAt(column);
    }
    
    public String getColumnName(int column)
    {
        // Return the name for the column...
        return columnNames[column] == null ? "No Names" : columnNames[column];
    } // public String getColumnName(int column)
    
    public void setValueAt(Object value, int row, int column)
    {
        dataChanged = true;
        RelationalTableColumnRowDataObject relationalTableColumnRowDataObject = (RelationalTableColumnRowDataObject) dataRows.get(row);
        
        relationalTableColumnRowDataObject.setValueAt(value, column);
        /*
        if(originalRows == null)            // on demand instantiation
            originalRows = new OriginalRowsContainer();
        int columnCount = ((Object[])(dataRows.elementAt(row))).length;
        Object[] copyRows = new Object[columnCount];
        for(int i = 0; i < columnCount; i++)
            copyRows[i] = ((Object[])(dataRows.elementAt(row)))[i];
        
        ((Object[])(dataRows.elementAt(row)))[column] = value;
        originalRows.add(row, copyRows, ((Object[])(dataRows.elementAt(row))));
         */
        //fireTableCellUpdated(row, column);
        
        //fireTableChanged(null);                     // Tell the table there is new model data
        //fireTableCellUpdated(row, column);
        //fireTableChanged(new TableModelEvent(this, row, row, column)); // Tell the table there is new model data
        fireTableChanged(new TableModelEvent(this, row)); // Tell the table there is new model data
    } // public void setValueAt(int row, int column)columnNames
    
    public boolean isCellEditable(int row, int column)
    {
        RelationalTableColumnRowDataObject relationalTableColumnRowDataObject = (RelationalTableColumnRowDataObject) dataRows.get(row);
        
        return relationalTableColumnRowDataObject.isCellEditable(column);
    } // public boolean isCellEditable(int row, int column)
    
    public boolean isPropertyCellEditable(int row, int column)
    {
        RelationalTableColumnRowDataObject relationalTableColumnRowDataObject = (RelationalTableColumnRowDataObject) dataRows.get(row);
        
        return relationalTableColumnRowDataObject.isPropertyCellEditable(column);
    } // public boolean isCellEditable(int row, int column)
    
    public Class getColumnClass(int c)
    {
        //return getValueAt(0, c).getClass();
        return columnTypeArray[c].getClass();
        
        /*
        switch(columnTypes[c])
        {
            case Types.ARRAY:
                return String.valueOf(0).getClass();
            case Types.BIGINT:
                System.out.println("column " + (c+1) +" Datatype is BIGINT" );
                //return Integer.TYPE;
                return new Integer(0).getClass();
            case Types.BIT:
                System.out.println("column " + (c+1) +" Datatype is BIT" );
                //return Boolean.TYPE;
                //Boolean.valueOf(false).getClass();
                //return String.valueOf(0).getClass();
                return new Boolean(true).getClass();
            case Types.TINYINT:
                System.out.println("column " + (c+1) +" Datatype is TINYINT" );
                //return Integer.TYPE;
                return new Integer(0).getClass();
            case Types.INTEGER:
                System.out.println("column " + (c+1) +" Datatype is INTEGER" );
                //return Integer.TYPE;
                return new Integer(0).getClass();
                //return String.valueOf(0).getClass();                
            case Types.OTHER:
                System.out.println("column " + (c+1) +" Datatype is OTHER" );
                return String.valueOf(0).getClass();
            case Types.VARCHAR:
                System.out.println("column " + (c+1) +" Datatype is VARCHAR" );
                return String.valueOf(0).getClass();
            default:
                System.out.println("column " + (c+1) +" Datatype is ?" );
                return String.valueOf(0).getClass();
        } // switch(args.length)
        */
    } // public Class getColumnClass(int c)
    
    /*
    public String getDataTypeMapper()
    {
        return dataTypeMapper;
    } // public String getDataTypeMapper()
     */
    
    /*
    public void setDataTypeMapper(String param_dataTypeMapper)
    {
        dataTypeMapper = param_dataTypeMapper;
    } // public void setDataTypeMapper(String dataTypeMapper)
     */
    
    /*
    public boolean save()
    {
        // INSERT INTO datatype (type_bool, type_int2, type_int4, type_int8, type_float, type_double, type_char_1, type_varchar_255, type_text, type_date, type_time, type_timestamp, type_oid, type_numeric, type_decimal) VALUES(true, 12, 1234, 12345678, 12.34, 1234.5678, 'a', 'a-z', 'A-Z', '2002/12/15', '12:00:22', '2z002-12-16 18:00:11.0', '', 1234.00, 1234.00)
        // SELECT * FROM datatype
        return false;
    } // public boolean save()
     */
    
    /*
    public boolean getDataChanged()
    {
        return dataChanged;
    } // public boolean hasChangedData()
     */
    
    /*
    public void setDataChanged(boolean param_dataChanged)
    {
        dataChanged = param_dataChanged;
    } // public void setDataChanged()
     */
    
    /*
    public OriginalRowsContainer getOriginalRows()
    {
        return originalRows;
    } // public originalRowsContainer getOriginalRows()
     */
    
    public String[] getColumnNames()
    {
        return columnNames;
    } // public String[] getColumnNames()
    
    /*
    public int getOriginalRowsCount()
    {
        return originalRowsCount;
    } // public int getOriginalRowsCount()
     */
    
    /*
    public int getCurrentRowsCount()
    {
        return dataRows.size();
    } // public int getCurrentRowsCount()
     */
    
    /*
    public void addNewRow()
    {
        Object[] emptyDataRow = new Object[columnCount];
        for(int i = 0; i < columnCount; i++)
            emptyDataRow[i] = null;
        dataRows.add(emptyDataRow);
        fireTableChanged(null);
    } // public void addNewRow()
     */
    
    /*
    public Object[] getRowDataAtIndex(int index)
    {
        return (Object[]) dataRows.get(index);
    } // public Object[] getRowData()
     */
    
    //------------------------------------------------------------------------
    // should be changed
    public Object getPropertyValueAt(int row, int propertyIndex)
    {
        RelationalTableColumnRowDataObject relationalTableColumnRowDataObject = (RelationalTableColumnRowDataObject) dataRows.get(row);
        
        return relationalTableColumnRowDataObject.getPropertyValueAt(propertyIndex);
    } // public RelationalTableColumnRowDataObject getRelationalTableColumnRowDataObject(int row)
    
    
    public void setPropertyValueAt(Object value, int row, int propertyIndex)
    {
        RelationalTableColumnRowDataObject relationalTableColumnRowDataObject = (RelationalTableColumnRowDataObject) dataRows.get(row);
        
        relationalTableColumnRowDataObject.setPropertyValueAt(value, propertyIndex);
        
        //fireTableChanged(null);                     // Tell the table there is new model data
    } // public RelationalTableColumnRowDataObject getRelationalTableColumnRowDataObject(int row)
    
    public Vector getModifiedDataRows()
    {
        Vector modifiedDataRows = new Vector();
        
        for(int i = 0; i < dataRows.size(); i++)
        {
            RelationalTableColumnRowDataObject dataObject = ((RelationalTableColumnRowDataObject) dataRows.get(i));
            if(dataObject.isChanged())
                modifiedDataRows.add(dataObject);
            
            //System.out.println("Row " + i + " is " + dataObject.isChanged());
            
        } // for(int i; i < modifiedDataRows.size(); i++)
        
        return modifiedDataRows;
    } // public Vector getModifiedDataRows()
     
} // class ResultsTableColumnModel extends AbstractTableModel