package jp.turbosql.modules.db.app.dialogs;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import java.sql.*;
import javax.swing.event.TableModelListener;
import javax.swing.event.*;
import java.util.Vector;

import jp.turbosql.modules.db.app.*;

public class TableAddFrame extends JFrame implements ActionListener, TableModelListener
{
    //------------------------------------------------------------------------
    // stand info for making database connections
    String serverIP;
    String serverPort;
    String username;
    String password;
    String dbName;
    //------------------------------------------------------------------------
    
    JTable table;                                       // Table
    RelationalTableColumnModel model;                                 // Table model for resultset
    JScrollPane resultsPane;
    
    // for column properties panel
    int singleSelectedRow = -1;
    boolean hasSingleSelectedRow = false;
    
    //-----------------------------------------------------------------------
    // modify here for adding column Properties
    JLabel columnDefaultValueLabel;
    JTextField columnDefaultValueField;
    JLabel columnCommentLabel;
    JTextField columnCommentField;
    JLabel columnNumericPrecisionLabel;
    JTextField columnNumericPrecisionField;
    //------------------------------------------------------------------------
    
    JButton okButton;
    JButton cancelButton;
    
    ActionListener refreshListener;
    
    public TableAddFrame(String serverIP, String serverPort, String username, String password, String dbName, ActionListener refreshListener)
    {
        super("Add Table - " + dbName);
        
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.refreshListener = refreshListener;
        
        setBounds(0, 0, 400, 300);                      // Set window bounds
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);     // Close window operation
        addWindowListener(new WindowHandler());         // Listener for window close
        getContentPane().setLayout(new BorderLayout());
        
        model = new RelationalTableColumnModel();                 // Create a table model
            
        model.addTableModelListener(this);              // listening to the model
                    
        table = new JTable(model);           // Create a table from the model
        resultsPane = new JScrollPane(table);       // Create scrollpane for table
        table.setAutoResizeMode(table.AUTO_RESIZE_OFF);
        table.setSurrendersFocusOnKeystroke(true);      // gives focus to the cell once the user starts typing
        
        //-------------------------------------------------------------------
        // needs to be re-done after a fireTableChanged(null);
        setUpColumnTypeColumn(table.getColumnModel().getColumn(2));
        
        table.getColumnModel().getColumn(0).setPreferredWidth(30);          // make the with smaller for the PK column
        table.getColumnModel().getColumn(1).setPreferredWidth(170);         // make the name column bigger than the rest
        table.getColumnModel().getColumn(2).setPreferredWidth(100);         // make the datatype column bigger
        //--------------------------------------------------------------------
        
        getContentPane().add(resultsPane, BorderLayout.CENTER);
        
        JTabbedPane tabbedPane = new JTabbedPane();
        
        //-----------------------------------------------------------------------
        // modify here for adding column Properties
        JPanel contentPanel = new JPanel(new GridLayout(3, 2)); // row by column
        
        tabbedPane.setBounds(0, 0, 100, 40);
        contentPanel.setPreferredSize(new Dimension(100, 60));
                
        columnDefaultValueLabel = new JLabel("Default value: ");
        columnDefaultValueField = new JTextField();
        columnCommentLabel = new JLabel("Description: ");
        columnCommentField = new JTextField();
        columnNumericPrecisionLabel = new JLabel("Numeric Precision");
        columnNumericPrecisionField = new JTextField();
                       
        contentPanel.add(columnDefaultValueLabel, 0);
        contentPanel.add(columnDefaultValueField, 1);
        contentPanel.add(columnCommentLabel, 2);
        contentPanel.add(columnCommentField, 3);
        contentPanel.add(columnNumericPrecisionLabel, 4);
        contentPanel.add(columnNumericPrecisionField, 5);
        //------------------------------------------------------------------------
        
        tabbedPane.addTab("Column Properties", null, contentPanel, "Properties");
        tabbedPane.setSelectedIndex(0);
        
        ListSelectionModel rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                //Ignore extra messages.
                if (e.getValueIsAdjusting()) return;
        
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {       // no rows are selected
                        processPreviousRowSelection();
                        // clear everything
                        hasSingleSelectedRow = false;
                        singleSelectedRow = -1;
                    //-----------------------------------------------------------------------
                    // modify here for adding column Properties
                        columnDefaultValueField.setText("");
                        columnCommentField.setText("");
                        columnNumericPrecisionField.setText("");
                    //-----------------------------------------------------------------------
                    } else {                            // selectedRow is selected
                        int minSelectedRow = lsm.getMinSelectionIndex();
                        int maxSelectedRow = lsm.getMaxSelectionIndex();
                        
                        //System.out.println("min: " + minSelectedRow);
                        //System.out.println("max: " + maxSelectedRow);
                    
                        if(minSelectedRow == maxSelectedRow)        // one row selected
                        {
                            processPreviousRowSelection();
                            hasSingleSelectedRow = true;
                            singleSelectedRow = minSelectedRow;
                            //-----------------------------------------------------------------------
                            // modify here for adding column Properties
                            columnDefaultValueField.setText((String) model.getPropertyValueAt(singleSelectedRow, 0));
                            columnCommentField.setText((String) model.getPropertyValueAt(singleSelectedRow, 1));
                            columnNumericPrecisionField.setText((String) model.getPropertyValueAt(singleSelectedRow, 2));
                            //-----------------------------------------------------------------------
                        } // if(minSelectedRow == maxSelectedRow)
                        else                                        // more than one row selected
                        {
                            processPreviousRowSelection();
                            // clear everything
                            hasSingleSelectedRow = false;
                            singleSelectedRow = -1;
                            //-----------------------------------------------------------------------
                            // modify here for adding column Properties
                            columnDefaultValueField.setText("");
                            columnCommentField.setText("");
                            columnNumericPrecisionField.setText("");
                            //-----------------------------------------------------------------------
                        } // else
                    
                    } // if (lsm.isSelectionEmpty()) {
                } // if (e.getValueIsAdjusting()) return;
        }); // rowSM.addListSelectionListener(new ListSelectionListener() {
        
        JPanel buttonPanel = new JPanel();
        okButton = new JButton("Ok");
        okButton.addActionListener(this);
        cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add(tabbedPane, BorderLayout.NORTH);
        southPanel.add(buttonPanel, BorderLayout.SOUTH);
        
        getContentPane().add(southPanel, BorderLayout.SOUTH);
        
        pack();
        setVisible(true);
    } // public TableAddFrame(String serverIP, String serverPort, String username, String password, String dbName)
    
    public void setUpColumnTypeColumn(TableColumn columnTypeColumn)
    {
        //Set up the editor for the sport cells.
        JComboBox comboBox = new JComboBox();
        
        String[] supportedDataTypes = RelationalTableColumnRowDataObject.getSupportedDataTypes();
        String[] unsupportedDataTypes = RelationalTableColumnRowDataObject.getUnsupportedDataTypes();
        
        for(int i = 0; i < supportedDataTypes.length; i++)
        {
            comboBox.addItem(supportedDataTypes[i]);
        } // for(int i = 0; i < supportedDataTypes.length; i++)
        
        comboBox.addItem("");
        comboBox.addItem("----------");
        comboBox.addItem("unsupported*");
        comboBox.addItem("----------");
        
        for(int i = 0; i < unsupportedDataTypes.length; i++)
        {
            comboBox.addItem(unsupportedDataTypes[i]);
        } // for(int i = 0; i < unsupportedDataTypes.length; i++)
        
        // should be re-factored.
        /*
        comboBox.addItem("serial");
        comboBox.addItem("serial8");
        comboBox.addItem("int2");
        comboBox.addItem("int4");
        comboBox.addItem("int8");
        comboBox.addItem("varchar");
        
        comboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            String ColumnType = (String)cb.getSelectedItem();
            
            }
        });
         */


        columnTypeColumn.setCellEditor(new DefaultCellEditor(comboBox));

        //Set up tool tips for the sport cells.
        DefaultTableCellRenderer renderer =
                new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for combo box");
        columnTypeColumn.setCellRenderer(renderer);

        //Set up tool tip for the sport column header.
        TableCellRenderer headerRenderer = columnTypeColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(
                     "Click the sport to see a list of choices");
        } 
    } // public void setUpColumnTypeColumn(TableColumn columnTypeColumn)
    
    private void processPreviousRowSelection()
    {
        if(!hasSingleSelectedRow)           // do nothing if single was not selected
            return;
        //-----------------------------------------------------------------------
        // modify here for adding column Properties
        model.setPropertyValueAt(columnDefaultValueField.getText(), singleSelectedRow, 0);   // hard coded column, to be modified later?
        model.setPropertyValueAt(columnCommentField.getText(), singleSelectedRow, 1);   // hard coded column, to be modified later?
        model.setPropertyValueAt(columnNumericPrecisionField.getText(), singleSelectedRow, 2);   // hard coded column, to be modified later?
        //-----------------------------------------------------------------------
    }  // private void processPreviousSelection()
    
    private String createTable()
    {
        Vector modifiedDataRows = model.getModifiedDataRows();
        int modSize = modifiedDataRows.size();
        if(modSize == 0)
            return "No columns to create table";
        
        // Get the name first
        String tableName = JOptionPane.showInputDialog(this, "Enter a name for the table:", "Add Table", JOptionPane.PLAIN_MESSAGE);
        // If name is nothing or "" we exit.
        if(tableName == null)                   // handle cancel, which which produce a null;
            return "Name not entered";
        if(tableName.equals(""))
            return "Name not entered";
        
        boolean[] relationalColumnPrimaryKeys = new boolean[modSize];
        String[] relationalColumnNames = new String[modSize];
        String[] relationalColumnTypes = new String[modSize];
        Integer[] relationalColumnLengths = new Integer[modSize];
        boolean[] relationalColumnAllowNullsArray = new boolean[modSize];
        String[] relationalColumnDefaultValues = new String[modSize];
        String[] relationalColumnComments = new String[modSize];
        Integer[] relationalColumnNumericPrecisions = new Integer[modSize];
        
        //System.out.println("modSize: " + modSize);
               
        for(int i = 0; i < modSize; i++)
        {
            RelationalTableColumnRowDataObject dataObject = ((RelationalTableColumnRowDataObject) modifiedDataRows.get(i));
            
            relationalColumnPrimaryKeys[i] = ((Boolean) dataObject.getValueAt(0)).booleanValue();
            relationalColumnNames[i] = (String) dataObject.getValueAt(1);
            relationalColumnTypes[i] = (String) dataObject.getValueAt(2);
            //----------------------------------------------------------------
            // we will pass a null if the length is not editable, so a length is not required for the column
            if(dataObject.isLengthEditable())
                relationalColumnLengths[i] = (Integer) dataObject.getValueAt(3);
            else
                relationalColumnLengths[i] = null;
            //----------------------------------------------------------------
            relationalColumnAllowNullsArray[i] = ((Boolean) dataObject.getValueAt(4)).booleanValue();
            relationalColumnDefaultValues[i] = (String) dataObject.getPropertyValueAt(0);
            relationalColumnComments[i] = (String) dataObject.getPropertyValueAt(1);
            try
            {
                relationalColumnNumericPrecisions[i] = Integer.getInteger(((String) dataObject.getPropertyValueAt(2)));
            } // try
            catch(NumberFormatException nfe)
            {
                ;
            } // catch(NumberFormatException nfe)
        } // for(int i = 0; i < modifiedDataRows.size(); i++)
        
        // PostgreSQLDataObject.createTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName, boolean[] relationalColumnPrimaryKeys, String[] relationalColumnNames, String[] relationalColumnTypes, Integer[] relationalColumnLengths, boolean[] relationalColumnAllowNullsArray, String[] relationalColumnDefaultValues, String[] relationalColumnComments, Integer[] relationalColumnNumericPrecisions);
        //PostgreSQLDataObject.createTable(serverIP, serverPort, username, password, dbName, tableName, relationalColumnPrimaryKeys, relationalColumnNames, relationalColumnTypes, relationalColumnLengths, relationalColumnAllowNullsArray, relationalColumnDefaultValues, relationalColumnComments, relationalColumnNumericPrecisions);
        return PostgreSQLDataObject.createTable(serverIP, serverPort, username, password, dbName, tableName, relationalColumnPrimaryKeys, relationalColumnNames, relationalColumnTypes, relationalColumnLengths, relationalColumnAllowNullsArray, relationalColumnDefaultValues, relationalColumnComments, relationalColumnNumericPrecisions);        
    } // private void createTable()
    
    class WindowHandler extends WindowAdapter
    {
        // Handler for window closing event
        public void windowClosing(WindowEvent e)
        {
            dispose();                                  // Release the window resources
            //System.exit(0);                             // End the application
        } // public void window(WindowEvent e)
    } // class WindowHandler  extends WindowAdapter
    
    public static void main(String args[])
    {
        /*
        JFrame frame = new JFrame("test");
        frame.setBounds(0, 0, 100, 100);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

         */
        TableAddFrame jFrame = new TableAddFrame("192.168.168.235", "5432", "postgres", "pg.test", "testdb3", null);
        //JDialog dialog = pane.createDialog(frame, "test dialog");
        //dialog.setVisible(true);
        //dialog.show();
    }
    
    /**
     * Invoked when an action occurs.
     */
    public void actionPerformed(ActionEvent e) {
        if(e.getSource() == okButton)
        {
            processPreviousRowSelection();
            String errorMSG = createTable();
            if(errorMSG == null)
                return;
            if(!errorMSG.equals(""))
            {
                //System.out.println("Some msg");
                JOptionPane.showConfirmDialog(this, errorMSG, "msg", JOptionPane.WARNING_MESSAGE);
            } // if(!errorMSG.equals(""))
            else                            // we finish it if there is no errorMSG
            {
                //System.out.println("Closing add pane");
                if(refreshListener != null)
                    refreshListener.actionPerformed(null);
                this.dispose();
            } // else
        } // if(e.getSource() == okButton)
        else if(e.getSource() == cancelButton)
        {
            //if(JOptionPane.showConfirmDialog(this, "Close?", "msg", JOptionPane.YES_NO_OPTION) == 0)
                this.dispose();
        } // else if(e.getSource() == cancelButton)
    }
    
    /**
     * This fine grain notification tells listeners the exact range
     * of cells, rows, or columns that changed.
     */
    public void tableChanged(TableModelEvent e) {
        //-------------------------------------------------------------------
        // needs to be re-done after a fireTableChanged(null);
        setUpColumnTypeColumn(table.getColumnModel().getColumn(2));
        
        table.getColumnModel().getColumn(0).setPreferredWidth(30);          // make the with smaller for the PK column
        table.getColumnModel().getColumn(1).setPreferredWidth(170);         // make the name column bigger than the rest
        table.getColumnModel().getColumn(2).setPreferredWidth(100);         // make the datatype column bigger
        //--------------------------------------------------------------------
        // needs to be re-drawn
        
        if(hasSingleSelectedRow)
        {
            //-----------------------------------------------------------------------
            // modify here for adding column Properties
            columnDefaultValueField.setText((String) model.getPropertyValueAt(singleSelectedRow, 0));
            columnCommentField.setText((String) model.getPropertyValueAt(singleSelectedRow, 1));
            columnNumericPrecisionField.setText((String) model.getPropertyValueAt(singleSelectedRow, 2));
            columnNumericPrecisionField.setEditable(model.isPropertyCellEditable(singleSelectedRow, 2));        // it will only change when one row is selected, but it should be the case when selecting a combo box.
            //-----------------------------------------------------------------------
        } // if(hasSingleSelectedRow)
        
        /*
        processPreviousRowSelection();
        hasSingleSelectedRow = true;
        singleSelectedRow = e.getFirstRow();
        tableDefaultValueField.setText((String) model.getPropertyValueAt(singleSelectedRow, 0));
        tableDescriptionField.setText((String) model.getPropertyValueAt(singleSelectedRow, 1));
         */
        // Process Property Changes       
    }
    
 // public static void main(String args[])
    
} // public class TableAddPane


