/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.io.File;
import java.io.IOException;
import java.util.*;

import org.openide.TopManager;
import org.openide.execution.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.*;

public class ExternalPlayer extends ProcessExecutor {
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor(
        Utilities.isWindows() ?
            "\"C:\\Program Files\\Windows Media Player\\mplayer2.exe\"" :
            "play",
        (Utilities.isWindows() ? "/Play " : "") +
            "{" + MyFormat.TAG_AUFILE + "}",
        NbBundle.getMessage(ExternalPlayer.class, "MSG_format_hint")
    );
    private static final long serialVersionUID = -4397529002559509129L;
    public ExternalPlayer() {
        setExternalExecutor(DEFAULT);
    }
    protected Process createProcess(ExecInfo info) throws IOException {
        throw new IllegalStateException("Should not be called");
    }
    protected Process createProcess(DataObject obj) throws IOException {
        if (!(obj instanceof ScoreDataObject)) {
            IOException ioe = new IOException("Wrong type: " + obj);
            TopManager.getDefault().getErrorManager().annotate(ioe, NbBundle.getMessage(ExternalPlayer.class, "EXC_wrong_type", obj.getLoader().getDisplayName()));
            throw ioe;
        }
        FileObject fo = ScoreDataLoader.findAudioFile((ScoreDataObject)obj);
        if (fo == null) {
            IOException ioe = new IOException("No .au: " + obj);
            TopManager.getDefault().getErrorManager().annotate(ioe, NbBundle.getMessage(ExternalPlayer.class, "EXC_No_AU_file_found"));
            throw ioe;
        }
        final File f = FileUtil.toFile(fo);
        if (f == null) {
            IOException ioe = new IOException("No .au: " + obj);
            TopManager.getDefault().getErrorManager().annotate(ioe, NbBundle.getMessage(ExternalPlayer.class, "EXC_file_must_be_local"));
            throw ioe;
        }
        return getExternalExecutor().exec(new MyFormat(f));
    }
    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.examples.modules.minicomposer.playing");
    }
    private static class MyFormat extends MapFormat {
        static final String TAG_AUFILE = "aufile";
        private static final long serialVersionUID = 6980703950237286310L;
        MyFormat(File aufile) {
            super(new HashMap(1));
            getMap().put(TAG_AUFILE, aufile.getAbsolutePath());
        }
    }
}
