# -*- coding: utf-8 -*-
import urllib,urllib2,ConfigParser,Queue,threading,functools,itertools
import xml.sax as sax
from xml.sax.handler import ContentHandler
from BeautifulSoup import BeautifulSoup
import config
user_agent = [('User-Agent',
               'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)')]
base_page = 'http://www.shoutcast.com/genre/'
genre_list_url = 'http://www.shoutcast.com/sbin/newxml.phtml'
query_host = 'http://yp.shoutcast.com/'
query_url_base = query_host + 'sbin/newxml.phtml?'
playlist_url =query_host + 'sbin/tunein-station.pls?id=%s'
limit_query = '&limit=%d'
search_query_url = query_url_base + 'search=%s&bitrate=%s&mt=%s'
search_limited_query_url = search_query_url + limit_query
genre_query_url = query_url_base +'genre=%s'
genre_limited_query_url = genre_query_url + limit_query
major_genre =[
'Alternative','Blues','Classical','Country','Decades',
'Easy Listening','Electronic','Folk','Hip-Hop/Rap',
'Holiday/Seasonal','Inspirational','International',
'Jazz','Latin','Metal','New Age',
'POP','R&B/Urban','Reggae','Rock','Soundtracks','Talk','Themes']

mime_type = {'audio/mpeg':'MP3',
             'audio/aacp':'AAC+',
             'audio/aac':'AAC',
             'audio/ogg':'OGG',
             'audio/flac':'FLAC'}
class StationListHandler(ContentHandler):
    def __init__(self,callback):
        self.__callback = callback

    def startElement(self, name, attrs):
        if name == 'station':
            info = (attrs.getValue('mt'),
                    attrs.getValue('br'),
                    attrs.getValue('genre'),
                    attrs.getValue('lc'),
                    attrs.getValue('ct'))

            self.__callback(attrs.getValue('name'),
                            attrs.getValue('id'),
                            info)

class GenreListHandler(ContentHandler):
    def __init__(self,callback):
        self.__callback = callback

    def startElement(self, name, attrs):
        if name == 'genre':
            self.__callback(attrs.getValue('name'))

class LimitedHTTPRedirectHandler(object):
    def __init__(self,redirect=1):
        self.redirect = redirect
        self.handler = urllib2.HTTPRedirectHandler()
        self.redirect_func = self.handler.redirect_request
        self.handler.redirect_request = self.redirect_request

    @property
    def redirector(self):
        return self.handler

    def redirect_request(self,*args,**kwds):
        if self.redirect > 0:
            self.redirect -= 1
            return self.redirect_func(*args,**kwds)

class StationActivity(object):
    @staticmethod
    def is_active(url):
        is_active_station = False
        handler = LimitedHTTPRedirectHandler()
        opener = urllib2.build_opener(handler.redirector)
        urllib2.install_opener(opener)
        try:
            urllib2.urlopen(url).headers
            is_active_station = True
        except:
            pass
        
        return is_active_station
class _ThreadPool(threading.Thread):
    __need_terminate = False
    __pool = []
    __super = None
    def __init__(self,func_iter,max_count=5):
        self.max_count = max_count
        self.func_iter = func_iter
        self.__super = super(self.__class__,self)
        self.__super.__init__()

    def terminate(self):
        self.__need_terminate = True
        self.__super.join()

    def run(self):
        for func in self.func_iter:
            if self.__need_terminate:
                break
            while not self.__need_terminate:
                if len(self.__pool) == self.max_count:
                    for worker in self.__pool:
                        if not worker.isAlive():
                            self.__pool.remove(worker)
                    continue
                worker = threading.Thread(target=func)
                worker.start()
                self.__pool.append(worker)
        for worker in self.__pool: worker.join()

class PlayListParser:
    def __init__(self,fileobj):
        self.parser = ConfigParser.RawConfigParser()
        self.parser.readfp(fileobj)

    def get_active_item(self):
        q = Queue.Queue()
        def __validate_activity(url):
            if StationActivity.is_active(url):
                q.put_nowait(url)
        def func_wrapper(item):
            return functools.partial(\
                __validate_activity,url=item)

        self.pool = _ThreadPool(itertools.imap(func_wrapper,
                                               self.iteritems())
                                )
        self.pool.start()
        link = q.get()
        self.pool.terminate()
        return link

#    def __del__(self):
#        self.pool.join()

    def get_item(self,sec,index):
        return self.parser.get(sec,'File%d' % index)

    def iteritems(self):
        sec ='playlist'
        entry_sum = self.parser.getint(sec,'numberofentries')
        if entry_sum == 1:
            yield self.get_item(sec,entry_sum)
        else:
            for i in range(1,entry_sum):
                yield self.get_item(sec,i)
     
def get_opener():
    opener = urllib2.build_opener()
    opener.addheaders = user_agent
    return opener

def get_genre_list():
    opener = get_opener()
    print opener.open(genre_list_url)

def printout(*args):
    print args

def translate_info(*args):
    args = args[0]
    mime,bitrate,genre = args[0:3]
    format = mime_type.get(mime,mime)
    info = '[%s %skb] Genre: %s' % (format,
                                    bitrate,
                                    genre)
    if len(args) > 3:
        info += '\n[Listen: %s] Playing: %s' % args[3:]
    return info

def saxing_data(url,handler):
    opener = get_opener()
    source = opener.open(url)
    parser = sax.make_parser()
    parser.setFeature(sax.handler.feature_namespaces, 0)
    parser.setContentHandler(handler)
    parser.parse(source)
    del source
    del parser
    
def get_all_genre(callback):
    handler = GenreListHandler(callback)
    saxing_data(genre_list_url,handler)

def get_playlist(id):
    opener = get_opener()
    return opener.open(playlist_url % id)

def get_stations(callback,genre,
                 limit=config.request_limit):
    target = genre_limited_query_url % (genre,limit)
    handler = StationListHandler(callback)
    saxing_data(target,handler)

def search_stations(callback,search_text,bitrate,codec,
                    limit=config.request_limit):
    target = search_limited_query_url % (urllib.quote(search_text),
                                         bitrate,codec,limit)
    handler = StationListHandler(callback)
    saxing_data(target,handler)
#get_stations(printout,major_genre[0],10)
#search_stations(printout,'big band')
#get_all_genre(printout)
#playlist = get_playlist('517565')
#playlist = get_playlist('5283')
#for entry in playlist.iteritems():
#    print entry
#print playlist.get_active_item()
