import sqlite3

class _SqlDefinition:
    get_table_names="SELECT name FROM sqlite_master WHERE type='table'"
    get_stations = 'SELECT * FROM station'
    create_station_table =\
'''CREATE TABLE station(
url TEXT PRIMARY KEY,name TEXT,protocol TEXT,codec TEXT,bitrate TEXT,genre TEXT);'''

    add_station =\
'''INSERT INTO station
VALUES("%s","%s","%s","%s","%s","%s")'''

    remove_station ='DELETE FROM station WHERE id=%s'

def sanitize_str(value):
    value = value.replace('"',"''")
    return value

class FavoriteListDataBase:
    def __init__(self,dbfile='favorite.db'):
        self._con = sqlite3.connect(dbfile)
        self._con.isolation_level = None
        if not self.__has_table():
            self.__initialize_db()

    def __initialize_db(self):
        cur = self._con.cursor()
        cur.execute(_SqlDefinition.create_station_table)

    def add_station(self,url,name,protocol_name,codec,bitrate,genre):
        cur = self._con.cursor()
        sql = _SqlDefinition.add_station % (url,
                                            sanitize_str(name),
                                            protocol_name,
                                            sanitize_str(codec),
                                            sanitize_str(bitrate),
                                            sanitize_str(genre))

        cur.execute(sql)

    def remove_station(self,url):
        cur = self._con.cursor()
        cur.execute(_SqlDefinition.remove_station % url)

    def get_stations(self,callback):
        cur = self._con.cursor()
        for row in cur.execute(_SqlDefinition.get_stations):
            url,name,protocol = row[0:3]
            callback(name,url,protocol,row[3:])

    def __has_table(self):
        cur = self._con.cursor()
        cur.execute(_SqlDefinition.get_table_names)
        return cur.fetchone() != None
