import urllib,urllib2,ConfigParser,Queue,threading,functools,itertools

def get_opener():
    opener = urllib2.build_opener()
    opener.addheaders =[('User-Agent',
                         'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)')]
    return opener

class LimitedHTTPRedirectHandler(object):
    def __init__(self,redirect=1):
        self.redirect = redirect
        self.handler = urllib2.HTTPRedirectHandler()
        self.redirect_func = self.handler.redirect_request
        self.handler.redirect_request = self.redirect_request

    @property
    def redirector(self):
        return self.handler

    def redirect_request(self,*args,**kwds):
        if self.redirect > 0:
            self.redirect -= 1
            return self.redirect_func(*args,**kwds)

class SiteActivity(object):
    @staticmethod
    def is_active(url):
        is_active_station = False
        handler = LimitedHTTPRedirectHandler()
        opener = urllib2.build_opener(handler.redirector)
        urllib2.install_opener(opener)
        try:
            urllib2.urlopen(url).headers
            is_active_station = True
        except:
            pass
        
        return is_active_station

class _ThreadPool(threading.Thread):
    __need_terminate = False
    __pool = []
    __super = None
    def __init__(self,func_iter,max_count=5):
        self.max_count = max_count
        self.func_iter = func_iter
        self.__super = super(self.__class__,self)
        self.__super.__init__()

    def terminate(self):
        self.__need_terminate = True
        self.__super.join()

    def run(self):
        for func in self.func_iter:
            if self.__need_terminate:
                break
            while not self.__need_terminate:
                if len(self.__pool) == self.max_count:
                    for worker in self.__pool:
                        if not worker.isAlive():
                            self.__pool.remove(worker)
                    continue
                worker = threading.Thread(target=func)
                worker.start()
                self.__pool.append(worker)
        for worker in self.__pool: worker.join()

class UrlCominucator:
    def __init__(self,urls):
        self.q = Queue.Queue()
        self.pool = _ThreadPool(
            itertools.imap(self.__validate_activity,
                           urls)
            )
        self.pool.start()

    def __validate_activity(self,url):
        if SiteActivity.is_active(url):
            self.q.put_nowait(url)

    def get_active_link(self):
        link = self.q.get()
        self.pool.terminate()
        return link
