<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: ExamInfo_success.php,v 1.1 2005/06/20 09:31:25 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>


</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach ($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" class="<?= ($subject->sid == $template['exam']->sid) ? "" : "disable " ?>sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
}
?>
		</ul>		
	<div class="div_clear">&#160;</div>
	</div>
	<div id="main">
		<div id="compose1">
			<div id="navi">
				<h1>科目とテスト名</h1>
			</div>
			<form action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'ExamInfo')) ?>" method="post">
				<input type="hidden" name="eid" value="<?= $template['exam']->eid ?>" />
				<table>
					<tr>
						<th>科目:</th>
						<td>
							<select name="sid" class="select_mid" onchange="selectSubject(this);">
<?php
foreach ($template['subjects'] as $subject) {
?>
								<option value="<?= $subject->sid ?>" <?= ($subject->sid == $template['exam']->sid) ? 'selected="selected"' : '' ?>><?= htmlspecialchars($subject->name) ?></option>
<?php
}
?>
							</select>
						</td>
					</tr>
					<tr>
						<th>テスト名:</th>
						<td>
							<input class="input_mid" name="name" type="text" value="<?= htmlspecialchars($template['exam']->name) ?>" size="40"/>
						</td>
					</tr>
					<tr>
						<th>再受験:</th>
						<td class="input_mid">
							<input class="input_mid" name="retry" type="radio" value="1" <?= ($template['exam']->retry) ? 'checked="checked"' : '' ?> />可
							<input class="input_mid" name="retry" type="radio" value="0" <?= (!$template['exam']->retry) ? 'checked="checked"' : '' ?> />不可
						</td>
					</tr>
					<tr>
						<th>解答と解説:</th>
						<td class="input_mid">
							<input class="input_mid" name="correct" type="radio" value="1" <?= ($template['exam']->correct) ? 'checked="checked"' : '' ?> />１問ずつ
							<input class="input_mid" name="correct" type="radio" value="0" <?= (!$template['exam']->correct) ? 'checked="checked"' : '' ?> />最後にまとめて
						</td>
					</tr>
					<tr>
						<th></th>
						<td>
							<input type="submit" value="次へ &gt;&gt;" name="exam_info_next"/>
						</td>
					</tr>
				</table>
			</form>
		</div>
		
	</div>
	<div id="side">
		<div class="side_menu">
			<h2>3ステップ</h2>
			<div class="progress">
			<span class="focus point">①</span><br/>
			<span>科目とテスト名</span><br/>
			<span class="arrow">↓</span><br/>
			<span class="point">②</span><br/>
			<span>テスト内容</span><br/>
			<span class="arrow">↓</span><br/>
			<span class="point">③</span><br/>
			<span>配信</span><br/>
			</div>
			
		</div>
	</div>
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>



</div>
</body>
</html>