<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Questions_success.php,v 1.1 2005/06/20 09:31:25 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
<script type="text/javascript">

var updateChoices = new Array();
var obj;
<?php
foreach($template['questions'] as $question) {
?>
updateChoices[<?= $question->number ?>] = new Array();
<?php
    for($i = 0; $i < count($question->choices); $i++) {
?>
obj = new Object();
obj.cid = '<?= htmlspecialchars($question->choices[$i]->cid) ?>';
obj.value = '<?= htmlspecialchars($question->choices[$i]->value) ?>';
updateChoices[<?= $question->number ?>][<?= $i ?>] = obj;
<?php
    }
}
?>

</script>
<script src="files/js/exam_questions.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach ($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" class="<?= ($subject->sid == $template['exam']->sid) ? "" : "disable " ?>sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
}
?>
		</ul>
		
		<div class="div_clear">&#160;</div>
	</div>
	
	
	<div id="main">
		<div id="compose2">
			<div id="navi">
				<h1>
					<?= htmlspecialchars($template['exam']->name) ?> 
                    &nbsp;<span class="exam_info">全<?= $template['questions_count'] ?>問&nbsp;合計点数<?= $template['total_point'] ?></span>
				</h1>
                <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','ExamInfo', array('eid'=>$template['exam']->eid))) ?>" class="operation">科目とテスト名を変更</a>
                | <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>" class="operation">キャンセル</a>
			</div>


<?php
if(count($template['questions'])) {
?>
			<div>
				<a href="javascript:expandAllQuestions();">すべて展開</a>
				<a href="javascript:collapseAllQuestions();">すべて閉じる</a>
			</div>
			
			<div id="exams">
<?php
	foreach($template['questions'] as $question) {
?>
				<div id="exam_<?= $question->number ?>_collapse" class="exam exam_collapse">
					<h1>
                        <a href="javascript:expandQuestion(<?= $question->number?>);">第<?= $question->number ?>問 &nbsp; <?= (mb_strlen($question->question) < 20) ? htmlspecialchars($question->question) : htmlspecialchars(mb_substr($question->question, 0, 20)."....") ?></a>
					</h1>
				</div>
				<div id="exam_<?= $question->number ?>_expand" class="exam exam_expand" style="display: none;">
					<h1>
						<a name="a_expand_<?= $question->number ?>" href="javascript:collapseQuestion(<?= $question->number ?>);">第<?= $question->number ?>問</a>
					</h1>
					<div id="exam_<?= $question->number ?>_body" class="exam_body">
						<a href="javascript:updateQuestion(<?= $question->number ?>);" class="operation">再編集</a>
						| <a href="javascript:deleteQuestion(<?= $question->qid ?>);" class="operation">削除</a>
						<table>
						<tr>
							<th>設問:</th>
							<td><?= nl2br(htmlspecialchars($question->question)) ?></td>
						</tr>
						<tr>
							<th>回答:</th>
							<td>
							<ol type="1">
<?php
		foreach($question->choices as $choice) {
?>
								<li><?= ($choice->correct == '1') ? '<span class="answer_right_saved">'.htmlspecialchars($choice->value).'</span>' : htmlspecialchars($choice->value) ?></li>
<?php
		}
?>
							</ol>
							</td>
						</tr>
						<tr>
							<th>配点:</th>
							<td><?= $question->point ?></td>
						</tr>
						<tr>
							<th>解説:</th>
							<td><?= nl2br(htmlspecialchars($question->explanation)) ?></td>
						</tr>
						
						</table>
						<div class="div_clear">&#160;</div>
					</div>
				</div>
				<div id="exam_<?= $question->number ?>_update" class="exam exam_update" style="display: none;">
<form id="update_form_<?= $question->number ?>" name="update_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'Questions')) ?>" method="post">
	<input type="hidden" name="eid" value="<?= $template['exam']->eid ?>" />
	<input type="hidden" name="update_submit" value="true" />
	<input type="hidden" name="qid" value="<?= $question->qid ?>" />
	<input type="hidden" id="update_correct_choice_<?= $question->number ?>" name="correct_choice" value="<?= htmlspecialchars($question->getCorrectValue()) ?>" />
	<input type="hidden" id="update_correct_choice_num_<?= $question->number ?>" value="<?= htmlspecialchars($question->getCorrectNumber()) ?>" />
	<input type="hidden" name="expand_num" value="<?= $question->number ?>" />
	
	<h1>
		<a name="a_update_<?= $question->number ?>" href="javascript:collapseQuestion(<?= $question->number ?>);">第<?= $question->number ?>問</a>
	</h1>
	<div class="exam_body exam_update_body">
		<table>
			<tr>
				<th>設問:</th>
				<td>
					<textarea id="update_question_<?= $question->number ?>" name="update_question" cols="" rows="4" style="width:95%;"><?= htmlspecialchars($question->question) ?></textarea>
				</td>
			</tr>
			<tr>
				<th>回答:</th>
				<td>
					<ol type="1" id="update_choices_<?= $question->number?>" class="console_answers"></ol>
					<input id="input_update_choice_<?= $question->number ?>" type="text" value="" size="35"/>
					<a class="operation" href="javascript:addUpdateChoice('<?= $question->number ?>');"><img src="files/images/plus.gif" alt="追加"/>追加</a>
				</td>
			</tr>
			<tr>
				<th>正解:</th>
				<td>
					<!--
					<div id="update_choice_right_<?= $question->number ?>">&nbsp;</div>
					-->
					<input type="text" id="update_choice_right_<?= $question->number ?>" name="update_choice_right" value="" disabled="disabled" style="background-color: white; color: black; border: 1px solid green;" size="50" />
				</td>
			</tr>
			<tr>
				<th>配点:</th>
				<td>
					<input id="update_point_<?= $question->number ?>" name="update_point" type="text" size="4" maxsize="4" value="<?= $question->point ?>">点
				</td>
			</tr>
			<tr>
				<th>解説:</th>
				<td>
					<textarea id="update_explanation_<?= $question->number ?>" name="update_explanation" cols="" rows="4" style="width:95%;"><?= htmlspecialchars($question->explanation) ?></textarea>
				</td>
			</tr>
			<tr>
				<th></th>
				<td>
					
				</td>
			</tr>
		</table>
		<div class="text_center">
			<input type="button" onclick="updateSubmit(<?= $question->number ?>);" value="この問題を更新" />
			&nbsp;
			<a href="javascript:expandQuestion(<?= $question->number ?>);" class="operation">取りやめ</a>
		</div>
	</div>
</form>
<form id="update_form_choice_<?= $question->number ?>" action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'Questions')) ?>" method="post" style="display:none">
	<input type="hidden" name="eid" value="<?= $template['exam']->eid ?>" />
	<input type="hidden" name="update_submit_choice" value="true" />
	<input type="hidden" name="qid" value="<?= $question->qid ?>" />
	<input type="hidden" name="update_num" value="<?= $question->number ?>" />
	<input type="hidden" id="update_correct_choice2_<?= $question->number ?>" name="correct_choice" value="<?= htmlspecialchars($question->getCorrectValue()) ?>" />
	<select id="update_choices_list_<?= $question->number ?>" name="update_choices_list[]" multiple="multiple"></select>
</form>
				</div>
<?php
	}
?>
			</div>
<?php
}
?>
			
			<a name="ques_add_position"></a>
			<div id="add_collapse" style="display:none;">
				<a href="javascript:expandAdd();">問題を追加する</a>
			</div>
			<div id="add_expand" class="console">
			
			
<form id="add_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'Questions')) ?>" method="post">
	<input type="hidden" name="eid" value="<?= $template['exam']->eid ?>" />
	<input type="hidden" name="add_submit" value="true" />
	<input type="hidden" name="nextnum" value="<?= $template['nextnum'] ?>" />
	<input id="add_correct_choice" type="hidden" name="correct_choice" value="" />
	<input id="add_correct_choice_num" type="hidden" name="correct_choice_num" value="" />
    <div>
	<table>
		<tr>
			<th></th>
			<td>
			第<?= $template['nextnum'] ?>問
			</td>
		</tr>
		<tr>
			<th>設問:</th>
			<td>
				<textarea id="add_question" name="question" class="input_mid" cols="" rows="4" style="width:95%;"></textarea>
			</td>
		</tr>
		<tr>
			<th>回答:</th>
			<td>
				<select id="add_choices_list" name="add_choices_list[]" multiple="multiple" style="display:none"></select>
				<ol type="1" id="add_choices" class="console_answers"></ol>
				<input id="input_add_choice" class="input_mid" type="text" value="" size="35"/>
				<a class="operation" href="javascript:addChoice();"><img src="files/images/plus.gif" alt="追加"/>追加</a>
			</td>
		</tr>
		<tr>
			<th>正解:</th>
			<td>
				<!--
				<div id="add_choice_right">&nbsp;</div>
				-->
				<input type="text" id="add_choice_right" value="" disabled="disabled" style="background-color: white; color: black; border: 1px solid green;" size="50" />
			</td>
		</tr>
		<tr>
			<th>配点:</th>
			<td>
				<input id="add_point" type="text" name="point" class="input_mid" size="4" maxsize="4" value="">点
			</td>
		</tr>
		<tr>
			<th>解説:</th>
			<td>
				<textarea name="explanation" class="input_mid" cols="" rows="4" style="width:95%;"></textarea>
			</td>
		</tr>
		<tr>
			<th></th>
			<td>
			</td>
		</tr>
	</table>
    <a href="javascript:addQuestion();" class="operation">この問題を追加</a>
    </div>
</form>


			</div>

<form id="delete_form" name="delete_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'Questions')) ?>" method="post" style="display:none">
	<input type="hidden" name="eid" value="<?= $template['exam']->eid ?>" />
	<input type="hidden" id="delete_qid" name="qid" value="" />
	<input type="hidden" name="delete_submit" value="true" />
</form>

			
<div class="console">
	<form action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'Questions')) ?>" method="post">
<?php
if($template['subject']->usable) {
?>
        <input type="button" onclick="checkDistribute('<?= htmlspecialchars(TemplateUtils::createLink('Exam','Distribute', array('eid'=>$template['exam']->eid))) ?>');" value="このテストを配信" />
<?php
} else {
?>
    この科目では配信できません
<?php
}
?>
    	| <a href="javascript:checkPrint('<?= htmlspecialchars(TemplateUtils::createLink('Exam','Print', array('eid'=>$template['exam']->eid))) ?>');" class="operation">テストを印刷</a>
    	| <a href="javascript:checkPrint('<?= htmlspecialchars(TemplateUtils::createLink('Exam','Print', array('eid'=>$template['exam']->eid,'correct' => 'true'))) ?>');" class="operation">正解を印刷</a>
	</form>
</div>
		</div>
		
	</div>

	<div id="side">
		<div class="side_menu">
			<h2>3ステップ</h2>
			<div class="progress">
            <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','ExamInfo', array('eid'=>$template['exam']->eid))) ?>">
			<span class="done point">①</span><br/>
			<span class="done">科目とテスト名</span><br/>
            </a>
			<span class="done arrow">↓</span><br/>
			<span class="focus point">②</span><br/>
			<span class="focus">テスト内容</span><br/>
			<span class="arrow">↓</span><br/>
			<span class="point">③</span><br/>
			<span>配信</span><br/>
			</div>
			
		</div>
	</div>
	
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
<?php
if(!is_null($template['expand_num'])) {
?>
<script language="javascript" type="text/javascript">
expandQuestion(<?= $template['expand_num'] ?>);
</script>
<?php
} elseif(!is_null($template['update_num'])) {
?>
<script language="javascript" type="text/javascript">
updateQuestion(<?= $template['update_num'] ?>);
getById('input_update_choice_<?= $template['update_num'] ?>').focus();
</script>
<?php
}
?>
</body>
</html>