-- admin_choice
-- テスト選択肢
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table admin_choice;

create table admin_choice(
  cid int not null AUTO_INCREMENT,
  eid int not null,
  qid int not null,
  value varchar(255),
  correct char(1) default '0',
  primary key(cid)
);
-- admin_exam
-- テスト
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table admin_exam;

create table admin_exam(
  eid int not null AUTO_INCREMENT,
  sid int not null,
  name varchar(255) not null,
  update_time datetime,
  retry char(1) default '0',
  correct char(1) default '0',
  share char(1) default '0',
  pub char(1) default '0',
  publish_time datetime,
  summary text,
  deadline_time datetime,
  primary key(eid)
);
-- admin_info
-- 教員情報
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table admin_info;

create table admin_info(
  aid         varchar(64) not null,
  pass        varchar(64) not null,
  name        varchar(64),
  message     text,
  information text,
  reserve1    varchar(255),
  reserve2    varchar(255),
  reserve3    varchar(255),
  primary key(aid)
);
-- admin_question
-- テスト設問
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table admin_question;

create table admin_question(
  qid int not null AUTO_INCREMENT,
  number int not null,
  eid int not null,
  question text,
  point int,
  explanation text,
  image_path varchar(255),
  share char(1) default '0',
  reserve1 varchar(64),
  reserve2 varchar(64),
  reserve3 varchar(64),
  reserve4 text,
  reserve5 text,
  primary key(qid,number,eid)
);
-- admin_subject
-- 科目マスタ
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table admin_subject;

create table admin_subject(
  sid int not null AUTO_INCREMENT,
  aid varchar(64) not null,
  name varchar(255) not null,
  summary text,
  usable char(1) default '0',
  del char(1) default '0',
  share char(1) default '0',
  pub char(1) default '0',
  primary key(sid)
);
-- user_choice
-- 学生テスト回答設問選択肢
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table user_choice;

create table user_choice(
  rid int not null,
  qid int not null,
  cid int not null,
  aid varchar(64) not null,
  uid varchar(6) not null,
  eid int not null,
  choice varchar(255) not null,
  primary key(rid,qid,cid)
);
-- user_exam
-- 学生テスト回答
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table user_exam;

create table user_exam(
  rid int not null AUTO_INCREMENT,
  aid varchar(64) not null,
  uid varchar(6) not null,
  eid int not null,
  reply_date datetime,
  points int,
  primary key(rid)
);
-- user_info
-- 学生情報
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table user_info;

create table user_info(
  aid varchar(64) not null,
  uid varchar(6) not null,
  pass varchar(6) not null,
  name varchar(64),
  mail varchar(64),
  number varchar(64),
  year varchar(8),
  regist char(1) default '0',
  del char(1) default '0',
  reserve1 varchar(255),
  reserve2 varchar(255),
  reserve3 varchar(255),
  reserve4 varchar(255),
  reserve5 varchar(255),
  primary key(aid,uid)
);
-- user_question
-- 学生テスト回答設問
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table user_question;

create table user_question(
  rid int not null,
  qid int not null,
  aid varchar(64) not null,
  uid varchar(6) not null,
  eid int not null,
  point int,
  primary key(rid,qid)
);
-- user_subject
-- 学生科目情報
-- $id$

-- Takayuki Tanimoto 2005/05/19
-- 作成

drop table user_subject;

create table user_subject(
  aid varchar(64) not null,
  uid varchar(6) not null,
  sid int not null,
  primary key(aid,uid,sid)
);
