<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: PrintAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once (OPT_DIR.'u-learning/data/AdminQuestion.class.php');

/**
 * PrintAction
 * 
 * 印刷
 */
class PrintAction extends AdminAction {

    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        // テスト取得
        $eid= $request->getParameter('eid');
        $exam= new AdminExam($eid, $db);
        $request->setAttribute('exam', $exam);

        // 科目名の取得
        $sname= $exam->getSubjectName($db);
        $request->setAttribute('sname', $sname);

        // テストの設問取得
        $questions= $exam->getQuestions($db);
        foreach ($questions as $key => $question) {
            // 各設問の選択肢をセットする
            $questions[$key]->setChoices($db);
        }
        $request->setAttribute('questions', $questions);

        // テストの設問数
        $request->setAttribute('questions_count', count($questions));

        // テストの合計点
        $request->setAttribute('total_point', $exam->getTotalPoint($db));

        // 正解の表示非表示
        $request->setAttribute('correct', $request->getParameter('correct'));

        return VIEW_SUCCESS;
    }
}
?>