<?php


// +---------------------------------------------------------------------------+
// | This file is part of the Mojavi package.                                  |
// | Copyright (c) 2003 Sean Kerr.                                             |
// |                                                                           |
// | For the full copyright and license information, please view the COPYRIGHT |
// | file that was distributed with this source code. If the COPYRIGHT file is |
// | missing, please visit the Mojavi homepage: http://www.mojavi.org          |
// +---------------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: StudentAuthorizationHandler.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

// include dependencies
require_once (AUTH_DIR.'AuthorizationHandler.class.php');

require_once (OPT_DIR.'u-learning/data/Student.class.php');
require_once (OPT_DIR.'u-learning/lib/DBHandler.class.php');
require_once (OPT_DIR.'u-learning/lib/TemplateUtils.class.php');

/**
 * StudentAuthorizationHandler
 *
 * @author  Mai kawasaki
 */
class StudentAuthorizationHandler extends AuthorizationHandler {

    function & StudentAuthorizationHandler() {
    }

    function execute(& $controller, & $request, & $user, & $action) {

        if (!$user->isAuthenticated() && $request->getParameter('aid') != '' && $request->getParameter('uid') != '' && $request->getParameter('pass') != '') {

            $aid = $request->getParameter('aid');
            $uid = $request->getParameter('uid');
            $pass = $request->getParameter('pass');

            if (!$request->hasAttribute('initialized')) {
                // ڑςADODBnh쐬
                $dbh = new DBHandler();

                //requestɐڑۊǂĂ
                $request->setAttribute('DB', $dbh);

                //xȂ߂̃tO
                $request->setAttribute('initialized', TRUE);
            }

            // DBڑ
            $DB = $request->getAttribute('DB');

            $sql = "select * from user_info where aid = ".$DB->qstr($aid)." and uid = ".$DB->qstr($uid)." and pass = ".$DB->qstr($pass)." and regist = '1' and del <> '1'";

            $array = $DB->GetRow($sql);

            if (count($array) > 0) {
                $user->setAuthenticated(true);
                // ǗIDZbg
                $user->setAttribute('aid', $aid);
                // [UIDZbg
                $user->setAttribute('uid', $uid);
                // pX[hZbg
                $user->setAttribute('pass', $pass);
            }

        }

        if (!$user->isAuthenticated()) {
			if($request->getParameter('aid') != ''){
		        $url = TemplateUtils :: createURL(AUTH_MODULE, AUTH_ACTION, array('aid'=>$request->getParameter('aid')));
		        header("Location: ".$url);
				return FALSE;
			}
            if ($controller->actionExists(AUTH_MODULE, AUTH_ACTION)) {

                // this action requires authentication, and the user isn't
                // authenticated
                $controller->forward(AUTH_MODULE, AUTH_ACTION);

                return FALSE;

            }

            // cannot find authentication action
            $error = 'Invalid configuration setting(s): '.'AUTH_MODULE ('.AUTH_MODULE.') or '.'AUTH_ACTION ('.AUTH_ACTION.')';

            trigger_error($error, E_USER_ERROR);

            exit;

        }

        $privilege = $action->getPrivilege($controller, $request, $user);

        if ($privilege != NULL && !isset ($privilege[1])) {

            $privilege[] = 'org.mojavi';

        }

        if ($privilege != NULL && !$user->hasPrivilege($privilege[0], $privilege[1])) {

            // user doesn't have access
            if ($controller->actionExists(SECURE_MODULE, SECURE_ACTION)) {

                $controller->forward(SECURE_MODULE, SECURE_ACTION);

                return FALSE;

            }

            // cannot find secure action
            $error = 'Invalid configuration setting(s): '.'SECURE_MODULE ('.SECURE_MODULE.') or '.'SECURE_ACTION ('.SECURE_ACTION.')';

            trigger_error($error, E_USER_ERROR);

            exit;

        }

        // user is authenticated, and has the required privilege or a privilege
        // is not required

        return TRUE;

    }

}
?>