<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: ListAction.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//

/** 
*	ListAction.class.php
*	Mai Kawasaki
*	2005/05/18
*/
require_once(OPT_DIR.'u-learning/config.php');
require_once(OPT_DIR.'u-learning/action/SecureStudentAction.class.php');
require_once(OPT_DIR.'u-learning/data/Subject.class.php');
require_once(OPT_DIR.'u-learning/data/SubjectStudent.class.php');
require_once(OPT_DIR.'u-learning/data/Admin.class.php');
require_once(BASE_DIR.'modules/Subject/config/list_config.php');

/** 
*	ListAction
*/
class ListAction extends SecureStudentAction {
    function execute (&$controller, &$request, &$user) {

		// uEU̔
		$type = $this->getUserAgentType();
		$request->setAttribute('type', $type);
		
		$DB = $request->getAttribute('DB');
		// Ȗڏ擾
		$sid = $request->getParameter('sid');
		$subject = new Subject($sid, $DB);
		
		// 擾
		$request->setAttribute('admin', new Admin($user->getAttribute('aid'), $DB));
		
		// eXg擾
		$subject_student = new SubjectStudent();
		$subject_student->sid = $sid;
		$page = $request->getParameter('page');
    	//$request->setAttribute('page', $page);
		//if(is_null($page) || $page == ''){
        if(!$page) {
			$page = 0;
		}
    	$request->setAttribute('page', $page);
		//$exam_count = $subject_student->getCountExams($DB);
        // ȖڃIuWFNgɂ点܂B
        $exam_count = $subject->getPubExamsCount();
        $first_num = $page * PUBLISHED_COUNT;
        $last_num = (($page * 5 + 5) < $exam_count) ? $page * 5 + 4 : $exam_count - 1;
		$is_next = (($first_num + PUBLISHED_COUNT) < $exam_count) ? true : false;
		$is_back = (($page - 1) >= 0) ? true : false; 
    	$request->setAttribute('is_next', $is_next);
    	$request->setAttribute('is_back', $is_back);
		//$exams_admin = $subject_student->getFiveExamsAdmin($first_num, $last_num, $DB);
        // ȖڃIuWFNgɂ点܂B
        $exams_admin = $subject->getPubExamsWithLimit($first_num, PUBLISHED_COUNT);
		
		// IȖڂ̉񓚏󋵎擾
		$student = new Student($user->getAttribute('aid'), $user->getAttribute('uid'), $DB);
		$exams_student = $student->getExamsStudentBySubject($sid, $DB);
		$request->setAttribute('subject', $subject);
		$request->setAttribute('exams_admin', $exams_admin);
		$request->setAttribute('exams_student', $exams_student);

		
		return VIEW_SUCCESS;
    }
}

?>