<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors:                                                             |
// +----------------------------------------------------------------------+
//
// $Id: StudentAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/20
//

require_once (OPT_DIR.'u-learning/action/DBAction.class.php');
require_once (OPT_DIR.'u-learning/lib/TemplateUtils.class.php');

/**
 * StudentAction
 * 
 * 認証不要な学生のページ
 */
class StudentAction extends DBAction {

    /**
     * Locationヘッダで別のページへリダイレクトする
     */
    function location($module, $action, $params = null, $place = null) {
        $url = TemplateUtils :: createURL($module, $action, $params, $place);
        header("Location: ".$url);
        return VIEW_NONE;
    }

    /**
     * ログインが必要か
     */
    function isSecure() {
        return false;
    }

    /**
     * PCまたは携帯の判別
     */

    function getUserAgentType() {
        $ua = $_SERVER["HTTP_USER_AGENT"];
        if (eregi("DoCoMo/2", $ua)) {
            // ドコモ FOMA (XHTML)
            return "mobile";
        } else
            if (eregi("DoCoMo/1", $ua)) {
                // ドコモ MOVA ブラウザフォン
                return "mobile";
            } else
                if (eregi("J-PHONE", $ua)) {
                    // ボーダフォン 1G,2G
                    return "mobile";
                } else
                    if (eregi("Vodafone|MOT-", $ua)) {
                        // ボーダフォン 3G  (XHTML)
                        return "mobile";
                    } else
                        if (isset ($_SERVER["HTTP_X_JPHONE_MSNAME"])) {
                            // ボーダフォン 旧1G?
                            return "mobile";
                        } else
                            if (eregi("KDDI-", $ua)) {
                                // WAP2  (XHTML)
                                return "mobile";
                            } else
                                if (eregi("UP.Browser", $ua)) {
                                    // WAP1 (HDML)
                                    return "mobile";
                                } else
                                    if (eregi("ASTEL", $ua)) {
                                        // ASTEL
                                        return "mobile";
                                    } else
                                        if (eregi("DDIPOCKET", $ua)) {
                                            // WILLCOM Air EDGE PHONE
                                            return "mobile";
                                        } else
                                            if (eregi("PDXGW", $ua)) {
                                                // WILLCOM EDGE LINK (Open Net Contents)
                                                return "mobile";
                                            } else
                                                if (eregi("L-mode", $ua)) {
                                                    // NTT L-mode
                                                    return "mobile";
                                                } else {
                                                    // PC
                                                    return "pc";
                                                }
    }
}
?>