<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: SubjectStudent.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/19
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');
require_once (OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once (OPT_DIR.'u-learning/data/StudentExam.class.php');

/**
 * SubjectStudent
 * 
 * 学生の選択した科目クラス
 */
class SubjectStudent extends DataObject {

    // 教員ID
    var $aid;

    // 学生ID
    var $uid;

    // 科目ID
    var $sid;

    // 科目
    var $name;

    // テスト一覧
    var $exams_admin;
    // テスト学生回答
    var $exams_student;

    /**
     * コンストラクタ
     */
    function SubjectStudent() {

    }

    /**
     * 配列（ハッシュ）から値をセットする
     */
    function setValues($array) {
        $this->aid= $array['aid'];
        $this->uid= $array['uid'];
        $this->sid= $array['sid'];
        $this->name= $array['name'];
    }

    /**
     * 自分自身をDBに追加する
     */
    function insert($db= null) {
        $this->setDB($db);
        $sql= "insert into user_subject (aid, uid, sid) values (".$this->DB->qstr($this->aid).", ".$this->DB->qstr($this->uid).", ".$this->sid.")";
        return $this->DB->Execute($sql);
    }

    /**
     * 自分自身をDBから削除する
     */
    function deleteSubject($db= null) {
        $this->setDB($db);
        $sql= "delete from user_subject where aid = ".$this->DB->qstr($this->aid)." and uid =  ".$this->DB->qstr($this->uid);
        return $this->DB->Execute($sql);
    }

    /**
     * 選択した科目のテスト一覧を取得
     */
    function getExamsAdmin($db= null) {
        $this->setDB($db);
        $sql= "SELECT * FROM admin_exam"." WHERE sid = ".$this->sid." AND publish_time <> '' order by publish_time desc";
        $this->exams_admin= array ();
        $all= $this->DB->GetAll($sql);
        foreach ($all as $row) {
            $admin_exam= new AdminExam();
            $admin_exam->setExamValues($row);
            array_push($this->exams_admin, $admin_exam);
        }
        return $this->exams_admin;

    }

	
	/**
	 * 選択した科目のテスト一覧を5件まで取得
	 */
	function getFiveExamsAdmin($num1 = null , $num2 = null , $db = null){
   		$this->setDB($db);
    	$sql = "SELECT * FROM admin_exam"." WHERE sid = ".$this->sid." AND publish_time <> '' order by publish_time desc"." limit ".$num1.", ".$num2;
 //		print $sql;
    	$this->exams_admin = array();
    	$all = $this->DB->GetAll($sql);
    	foreach($all as $row) {
    		$admin_exam = new AdminExam();
    		$admin_exam->setExamValues($row);
    		array_push($this->exams_admin, $admin_exam);
		}	
    	return $this->exams_admin;
	
	}
	
	/**
	 * 選択した科目のテスト数を取得
	 */
	function getCountExams($db = null){
   		$this->setDB($db);
    	$sql = "SELECT count(*) FROM admin_exam"." WHERE sid = ".$this->sid." AND publish_time <> '' ";
    	$this->exams_count = $this->DB->GetOne($sql);
     	return $this->exams_count;
	
	}

    /**
     * 選択した科目のテスト回答一覧を取得
     */
    function getExamsStudent($db= null) {
        $this->setDB($db);
        $sql= "SELECT * FROM user_exam "." WHERE sid = ".$this->DB->qstr($this->sid)." ORDER BY rid, reply_date ";
        $all= $this->DB->GetAll($sql);
        $this->exams_student= array ();
        foreach ($all as $row) {
            $student_exam= new StudentExam();
            $student_exam->setExamValues($row);
            array_push($this->exams, $student_exam);
        }
        return $this->exams_student;

    }

}
?>