<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: TemplateUtils.class.php,v 1.2 2005/06/21 01:21:59 snapshot Exp $
//
// Description:
// 2005/05/18
//

/**
 * TemplateUtils
 * 
 * テンプレート内で使える関数をもつクラス
 */
class TemplateUtils {

    // Logger
    var $deflog;

    function TemplateUtils() {
        $this->deflog= & LogManager :: getLogger();
    }

    /**
     * パス、モジュール、アクション、パラメータ、アンカーから URL を作成する
     */
    function makeURL($path, $module, $action, $params= null, $place= null) {
        $query= array ();
        if (is_array($params)) {
            foreach ($params as $key => $value) {
                array_push($query, "$key=$value");
            }
        }
        if (ini_get("session.use_trans_sid") && strlen(SID))
            array_push($query, SID);

        if (MOD_REWRITE) {
            $url= $path."$module/$action/page";
            if (count($query))
                $url .= '?'.implode('&', $query);
        } else {
            $url= $path."index.php?module=".$module."&action=".$action;
            if (count($query))
                $url .= '&'.implode('&', $query);
        }

        if (!is_null($place))
            $url .= "#".$place;
        return $url;
    }

    /**
     * モジュール、アクション、パラメータからリンク用 URL を作成する
     */
    function createURL($module, $action, $params= null, $place= null) {
        return TemplateUtils :: makeURL(ROOT_PATH, $module, $action, $params, $place);
    }

    /**
     * モジュール、アクション、パラメータからリンク用 URL を作成する
     */
    function createLink($module, $action, $params= null, $place= null) {
        return TemplateUtils :: createURL($module, $action, $params, $place);
    }

    /**
     * 管理者用 URL を作成する
     */
    function adminURL($module, $action, $params= null, $place= null) {
        return TemplateUtils :: makeURL(ADMIN_URL, $module, $action, $params, $place);
    }

    /**
     * ユーザ用 URL を作成する
     */
    function userURL($module, $action, $params= null, $place= null) {
        return TemplateUtils :: makeURL(USER_URL, $module, $action, $params, $place);
    }

    /**
     * 科目IDからCSS用の番号を取得する
     */
    function subType($sid) {
        return $sid % 5;
    }

    /**
     * 日付のフォーマットを変更する
     */
    function formatDateTime($time, $format= '%Y/%m/%d %H:%M:%S') {
        if (!$time)
            return '';
        // strtotime で認識できる文字列でなければならない
        return strftime($format, strtotime($time));
    }
}
?>