<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Input_input.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">

	<div id="main">
		<div id="compose2">
			
			<div id="navi">
				<h1>設定</h1>
                <!--
				<a href="#" class="operation" onclick="getById('conf_form').submit();">変更を保存</a>
                -->
			</div>
			
			<form id="conf_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Config', 'Input')) ?>" method="post">
				<input type="hidden" name="conf_form_submit" value="true" />
				
                <input type="submit" value="変更を保存" />
                
				<div class="console">
					<div class="console_header">パスワードの変更</div>
					<table>
						<tr>
							<th>現在のパスワード:</th>
							<td>
								<input name="pass_current" class="input_mid" type="password" value="" size="35" maxlength="256" />
							</td>
						</tr>
						<tr>
							<th>新しいパスワード:</th>
							<td>
								<input name="pass_new" class="input_mid" type="password" value="" size="35" maxlength="256" />
							</td>
						</tr>
						<tr>
							<th>新しいパスワード（確認）:</th>
							<td>
								<input name="pass_new2" class="input_mid" type="password" value="" size="35" maxlength="256" />
							</td>
						</tr>
					</table>
					<div class="text_right">
						パスワードは入力しなければ更新されません。
					</div>
				</div>
				
				<div class="div_clear">&nbsp;</div>
				
				<div class="console">
					<div class="console_header">教員情報の変更</div>
					<table>
						<tr>
							<th>氏名:</th>
							<td>
								<input name="name" class="input_mid" type="text" value="<?= htmlspecialchars($template['name']) ?>" size="35" maxlength="256" />
							</td>
						</tr>
						<tr>
							<th>ログインページ<br />メッセージ:</th>
							<td>
								<textarea name="message" class="input_mid" cols="" rows="4" style="width:95%;"><?= htmlspecialchars($template['message']) ?></textarea>
							</td>
						</tr>
						<tr>
							<th>お知らせ:</th>
							<td>
								<textarea name="information" class="input_mid" cols="" rows="4" style="width:95%;"><?= htmlspecialchars($template['information']) ?></textarea>
							</td>
						</tr>
					</table>
				</div>
				
			</form>
			
			<div class="div_clear">&nbsp;</div>
			
			<div class="console">
				<div class="console_header">学生アクセス用URL</div>
				<a href="<?= htmlspecialchars(TemplateUtils::userURL('Login', 'Login', array('aid'=>$template['admin']->aid))) ?>" target="_blank" class="long_url"><?= htmlspecialchars(TemplateUtils::userURL('Login', 'Login', array('aid'=>$template['admin']->aid))) ?></a>
			</div>
		</div>
	</div>
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
</body>
</html>