<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Print_correct.php,v 1.1 2005/06/20 09:31:25 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title><?= htmlspecialchars($template['exam']->name) ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/print.css" type="text/css" />


</head>
<body>
<div class="container">
<div>
	<table class="header" width="98%" align="center">
		<tr>
			<th width="20%">科目</th>
			<td width="30%"><?= htmlspecialchars($template['sname']) ?></td>
			<th width="20%">テスト名</th>
			<td width="30%"><?= htmlspecialchars($template['exam']->name) ?></td>
		</tr>
	</table>
	<div class="div_right">
		全&nbsp;<?= $template['questions_count'] ?>&nbsp;問
		&nbsp;合計&nbsp;<?= $template['total_point'] ?>&nbsp;点
	</div>
</div>

<div class="contents">
	<table class="exam_table">
<?php
foreach($template['questions'] as $question) {
?>
		<tr class="no_break">
			<td width="90%">
				<table width="100%" class="question_table">
					<tr>
						<th class="num">問<?= $question->number ?>.&nbsp;&nbsp;</th>
						<td class="question" colspan=2><?= nl2br(htmlspecialchars($question->question)) ?></td>
					</tr>
					<tr>
						<th>&nbsp;</th>
						<td class="choices">
							<ol type="1">
<?php
	foreach($question->choices as $choice) {
?>
								<li><?= htmlspecialchars($choice->value) ?></li>
<?php
	}
?>
							</ol>
						</td>
					</tr>
				</table>
			</td>
			<td width="10%" class="answer">
				<div class="div_answer_box">
					配点&nbsp;<?= htmlspecialchars($question->point) ?>
					<table border="1" cellpadding="0" cellspacing="0">
						<tr>
							<td><?= htmlspecialchars($question->getCorrectNumber()) ?></td>
						</tr>
					</table>
				</div>
			</td>
		</tr>
<?php
}
?>		
	</table>
	
</div>

<!--
<div class="footer">
	<div class="div_right">
	Powerd by <strong>Uラーニング</strong> Ver. 0.0.1
	</div>
</div>
-->

</div>
</body>
</html>