<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: ExplanationAction.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/18
//

/** 
*	ExplanationAction.class.php
*	Mai Kawasaki
*	2005/05/18
*/
require_once(OPT_DIR.'u-learning/config.php');
require_once(OPT_DIR.'u-learning/action/SecureStudentAction.class.php');
require_once(OPT_DIR.'u-learning/data/Admin.class.php');
require_once(OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once(OPT_DIR.'u-learning/data/AdminQuestion.class.php');
require_once(OPT_DIR.'u-learning/data/AdminChoice.class.php');
require_once(OPT_DIR.'u-learning/data/StudentExam.class.php');
require_once(OPT_DIR.'u-learning/data/StudentQuestion.class.php');
require_once(OPT_DIR.'u-learning/data/StudentChoice.class.php');

/** 
*	ExplanationAction
*/
class ExplanationAction extends SecureStudentAction {
    function execute (&$controller, &$request, &$user) {
	
		// uEU̔
		$type = $this->getUserAgentType();
		$request->setAttribute('type', $type);
		
		$DB = $request->getAttribute('DB');
		$exam_admin = unserialize($_SESSION['exam_admin']);
		$number = $request->getParameter('number');
		$rid = $request->getParameter('rid');	
		// 擾
		$request->setAttribute('admin', new Admin($user->getAttribute('aid'), $DB));

		// uցv{^ꂽ
		if($request->getParameter('next')){
			$number += 1;
			// ̖肪ȂƂ
			$next = $exam_admin->getQuestionByNumber($number, $DB);
			if( $next->qid == '' || is_null($next->qid) ){
				$this->location('Exam', 'Result', array('rid'=>$rid));
				return VIEW_NONE;
			}
			
			
		// u߂v{^ꂽ
		} else if($request->getParameter('back')){
			$number = $number - 1;
			// ߂{^\tO
			if( $number < 1){
				$this->location('Exam', 'Result', array('rid'=>$rid));
				return VIEW_NONE;
			} 
			
		// umFIv{^ꂽ
		} else if($request->getParameter('end')){
			$this->location('Exam', 'Result', array('rid'=>$rid));
			return VIEW_NONE;
			
		}
		
		// 擾
		$question_admin = $exam_admin->getQuestionByNumber($number, $DB);
		// ̉񓚂擾
		$question_student = new StudentQuestion($rid, $question_admin->qid , $DB);
		$choice_student = new StudentChoice($rid, $question_student->qid, $DB);
		// 𓚁E擾
		$choice_admin = new AdminChoice($choice_student->cid, $DB);
		if($choice_admin->correct == '1'){
			$request->setAttribute('result', '');
		} else{
			$request->setAttribute('result', 's');
		}
		$question_admin->setChoices($DB);
		$correct = $question_admin->getCorrectValue();
		$request->setAttribute('exam_admin', $exam_admin);
		$request->setAttribute('count', unserialize($_SESSION['count']));
		$request->setAttribute('rid', $rid);
		$request->setAttribute('question_admin', $question_admin);
		$request->setAttribute('choice_student', $choice_student);
		$request->setAttribute('correct', $correct);
		return VIEW_SUCCESS;
    }
}

?>