<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: ResultAction.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/18
//

/** 
*	ResultAction.class.php
*	Mai Kawasaki
*	2005/05/18
*/
require_once(OPT_DIR.'u-learning/config.php');
require_once(OPT_DIR.'u-learning/action/SecureStudentAction.class.php');
require_once(OPT_DIR.'u-learning/data/StudentExam.class.php');
require_once(OPT_DIR.'u-learning/data/Admin.class.php');

/** 
*	ResultAction
*/
class ResultAction extends SecureStudentAction {

    function execute (&$controller, &$request, &$user) {
		
		// uEU̔
		$type = $this->getUserAgentType();
		$request->setAttribute('type', $type);
		
		$DB = $request->getAttribute('DB');
		// 擾
		$request->setAttribute('admin', new Admin($user->getAttribute('aid'), $DB));

		$now_time = time();
		$time_over = false;
		if ($request->getParameter('now_time') != ''){
			$now_time = $request->getParameter('now_time');
			$time_over = true;	
		}
		$request->setAttribute('time_over', $time_over);
		// eXg擾
		$exam_admin =  unserialize($_SESSION['exam_admin']);
		$rid = $request->getParameter('rid');
		$exam_student =  new StudentExam($rid, $DB);
		// eXgXV
		$exam_student->setPoints($DB);
		if($exam_student->reply_date == '' || is_null($exam_student->reply_date)){
			$exam_student->reply_date = date('Y-m-d H:i:s', $now_time);
			$exam_student->update($DB);
		}
		
		$request->setAttribute('exam_admin', $exam_admin);
		$request->setAttribute('exam_student', $exam_student);
		
		return VIEW_SUCCESS;
    }


}

?>