/**********************************************************************
 * test_util.c                                              August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifdef __KERNEL__
#include <linux/slab.h>
#else
#include "compat.h"
#endif

#include "test_util.h"

void asym_print_char(char *prefix, char *in, unsigned len)
{
	int i;
	char *str;
	char *p;

	str = (char *) kmalloc(strlen(prefix) + 15 + len * 3 + 1, GFP_KERNEL);
	if (!str) {
		return;
	}

	snprintf(str, strlen(prefix) + 10 + 1, "%s[%u] = ", prefix, len);

	p = str + strlen(str);
	for (i = 0; i < len; i++) {
		snprintf(p, 4, "%.2x ", (*in++)&0xff);
		p += 3;
	}
	*(p - 1) = '\n';
	*(p) = '\0';

	printk("%s", str);
	kfree(str);
}

void asym_print_unsx(char *prefix, unsx *in, unsigned len)
{
	int i;
	char *str;
	char *p;

	str = (char *) kmalloc(strlen(prefix) + 15 + len * 9 + 1, GFP_KERNEL);
	if (!str) {
		return;
	}

	snprintf(str, strlen(prefix) + 10 + 1, "%s[%u] = ", prefix, len);

	p = str + strlen(str);
	for (i = 0; i < len; i++) {
		snprintf(p, 10, "%.8x ", *in++);
		p += 9;
	}
	*(p - 1) = '\n';
	*(p) = '\0';

	printk("%s", str);
	kfree(str);
}
