/**********************************************************************
 * kssl.h                                                   August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef __KSSL_H
#define __KSSL_H

#include "types/base_t.h"

#define KSSL_CTL_VERSION_MAGIC 0x77
#define KSSL_CTL_VERSION_MAJOR 0
#define KSSL_CTL_VERSION_MINOR 0
#define KSSL_CTL_VERSION_PATCH 1
#define KSSL_CTL_VERSION                                                     \
        ((KSSL_CTL_VERSION_MAGIC << 24) |                                    \
	 (KSSL_CTL_VERSION_MAJOR << 16) |                                    \
	 (KSSL_CTL_VERSION_MINOR <<  8) |                                    \
	 (KSSL_CTL_VERSION_PATCH))

#define KSSL_CTL_BASE (64+1024+128)

#define KSSL_CTL_CERT_KEY         KSSL_CTL_BASE
#define KSSL_CTL_CERT_KEY_LEN     (KSSL_CTL_BASE+1)
#define KSSL_CTL_R_IP_PORT        (KSSL_CTL_BASE+2)
#define KSSL_CTL_CIPHERS          (KSSL_CTL_BASE+3)
#define KSSL_CTL_CIPHERS_LEN      (KSSL_CTL_BASE+4)
#define KSSL_CTL_ASYM_METHODS     (KSSL_CTL_BASE+5)
#define KSSL_CTL_ASYM_METHODS_LEN (KSSL_CTL_BASE+6)
#define KSSL_CTL_DAEMON_ADD       (KSSL_CTL_BASE+7)
#define KSSL_CTL_DAEMON_DEL       (KSSL_CTL_BASE+9)
#define KSSL_CTL_DAEMON_MODE      (KSSL_CTL_BASE+10)
#define KSSL_CTL_DAEMONS          (KSSL_CTL_BASE+11)
#define KSSL_CTL_DAEMONS_LEN      (KSSL_CTL_BASE+12)
#define KSSL_CTL_FLUSH            (KSSL_CTL_BASE+13)
#define KSSL_CTL_LAST             KSSL_CTL_FLUSH


typedef struct {
	u32 version;
	u32 vaddr;
	u16 vport;
	u16 pad;
} kssl_ctl_t;


typedef enum {
	kssl_key_type_none    = 0,
	kssl_key_type_rsa     = 1,
	kssl_key_type_dsa     = 2,
	kssl_key_type_dh      = 3,
	kssl_key_type_unknown = 255
} kssl_key_type_t;

#define KSSL_KEY_TYPE_RSA "RSA" /* Supported */
#define KSSL_KEY_TYPE_DSA "DSA" /* Not supported */
#define KSSL_KEY_TYPE_DH  "DH"  /* Not supported */


typedef enum {
	kssl_asym_method_none       = 0,
	kssl_asym_method_software   = 1,
	kssl_asym_method_aep_user   = 2,
	kssl_asym_method_aep_kernel = 3,
	kssl_asym_method_unknown    = 255
} kssl_asym_method_t;

#define KSSL_ASYM_METHOD_SOFTWARE   "software"   /* Supported */
#define KSSL_ASYM_METHOD_AEP_USER   "AEP_user"   /* Supported */
#define KSSL_ASYM_METHOD_AEP_KERNEL "AEP_kernel" /* Not supported */


typedef enum {
	kssl_daemon_mode_none      = 0,
	kssl_daemon_mode_running   = 1,
	kssl_daemon_mode_stopped   = 2,
	kssl_daemon_mode_quiescent = 3,
	kssl_daemon_mode_unknown   = 255
} kssl_daemon_mode_t;

#define KSSL_DAEMON_MODE_RUNNING   "running"
#define KSSL_DAEMON_MODE_STOPPED   "stopped"
#define KSSL_DAEMON_MODE_QUIESCENT "quiescent"


#endif /* __KSSL_H */
