/**********************************************************************
 * security_parameters_t.h                                  August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _STATE_T_H
#define _STATE_T_H

#include "types/base_t.h"

#ifdef __KERNEL__
#include <asm/types.h>
#include <linux/string.h>
#else
#include <string.h>
#endif

typedef enum {
	ce_server=0,
	ce_client=1
} connection_end_t;


typedef enum {
	bca_null=0,
	bca_rc4=1,
	bca_rc2=2,
	bca_des=3,
	bca_3des=4,
	bca_des40=5,
	bca_idea=6,
	bca_aes_128=7,
	bca_aes_256=8
} bulk_cipher_algorithm_t;


typedef enum {
	ct_stream=0,
	ct_block=1
} cipher_type_t;


typedef enum {
	ie_false=0,
	ie_true=1
} is_exportable_t;


typedef enum {
	ma_null=0,
	ma_md5=1,
	ma_sha=2
} mac_algorithm_t;


typedef enum {
	cm_null=0,
	cm_last=255
} compression_method_t;

#define COMPRESSION_METHOD_NLEN 1

#define RANDOM_NBYTES 32
#define MASTER_SECRET_LEN 48

typedef struct {
	connection_end_t entity;
	bulk_cipher_algorithm_t bulk_cipher_algorithm;
	cipher_type_t cipher_type;
	size_t key_size;                                   /* In bytes */
	size_t key_material_length;                        /* In bytes */
	is_exportable_t is_exportable;
	mac_algorithm_t mac_algorithm;
	size_t hash_size;                                  /* In bytes */
	compression_method_t compression_algorithm;
	opaque_t master_secret[MASTER_SECRET_LEN];
	opaque_t client_random[RANDOM_NBYTES];
	opaque_t server_random[RANDOM_NBYTES];

	/* Extra Stuff */
	size_t block_size;                                 /* In bytes */
} security_parameters_t;


static inline void security_parameters_init(security_parameters_t *sp, 
		connection_end_t entity)
{
	memset(sp, 0, sizeof(security_parameters_t));
	sp->entity = entity;

	/* Not needed because of memset */
	/* sp->bulk_cipher_algorithm = bca_null; */
	/* sp->compression_algorithm = cm_null; */

	sp->cipher_type = 255;
	sp->is_exportable = 255;
}

#endif /* _STATE_T_H */
