/**********************************************************************
 * css.c                                                    August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/version.h>

#include "record.h"
#include "message.h"
#include "conn.h"
#include "log.h"

#include "types/change_cipher_spec_t.h"


static int kssl_change_cipher_spec_write(kssl_record_t *cr, void *data)
{
	u8 *buf;

	KSSL_DEBUG(12, "kssl_change_cipher_spec_write enter\n");

	buf = cr->iov->iov_base;

	/* Record Head */
	kssl_record_head_set(cr, ct_change_cipher_spec, 1);

	/* Fill out change cipher specs structure */
	if (cr->msg)
		kssl_message_destroy(cr->msg);
	cr->msg = kssl_message_create(ct_change_cipher_spec);
	if(!cr->msg) {
		KSSL_DEBUG(6, "change_cipher_spec_write: "
				"kssl_message_create\n");
		return(-ENOMEM);
	}
	cr->msg->data.css.type = ccst_change_cipher_spec;

        /* Body */
	change_cipher_spec_to_buf(&(cr->msg->data.css), buf + TLS_HEAD_NLEN);

	return(0);
}


int kssl_change_cipher_spec_send(kssl_record_t *cr, int reuse) 
{
	return(kssl_record_build_send(cr, kssl_change_cipher_spec_write,
			1 + TLS_HEAD_NLEN, NULL, reuse));
}


int kssl_change_cipher_spec_process(kssl_record_t *cr, alert_t *alert) {
	int status;
	
	KSSL_DEBUG(12, "kssl_change_cipher_spec_process enter\n");
	status = kssl_conn_activate_sec_param_in(cr->conn);
	if(status < 0) {
		KSSL_DEBUG(6, "kssl_change_cipher_spec_process: "
				"kssl_conn_activate_sec_param_in\n");
		return(status);
	}
	kssl_record_destroy(cr);
	return(0);
}


