/**********************************************************************
 * message_mask.h                                           August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef __KSSLD_MESSAGE_MASK_H
#define __KSSLD_MESSAGE_MASK_H

#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/version.h>

#include "record.h"


#define KSSL_CONN_M_ALERT                 0x0000001
#define KSSL_CONN_M_CHANGE_CIPHER_SPEC    0x0000002
#define KSSL_CONN_M_APPLICATION_DATA      0x0000004

#define KSSL_CONN_M_H_HELLO_REQUEST       0x0000008
#define KSSL_CONN_M_H_CLIENT_HELLO        0x0000010
#define KSSL_CONN_M_H_SERVER_HELLO        0x0000020
#define KSSL_CONN_M_H_CERTIFICATE         0x0000040
#define KSSL_CONN_M_H_SERVER_KEY_EXCHANGE 0x0000080
#define KSSL_CONN_M_H_CERTIFICATE_REQUEST 0x0000100
#define KSSL_CONN_M_H_SERVER_HELLO_DONE   0x0000200
#define KSSL_CONN_M_H_CERTIFICATE_VERIFY  0x0000400
#define KSSL_CONN_M_H_CLIENT_KEY_EXCHANGE 0x0000800
#define KSSL_CONN_M_H_FINISHED            0x0001000

#define KSSL_CONN_M_HANDSHAKE                                                 \
	( KSSL_CONN_M_H_HELLO_REQUEST | KSSL_CONN_M_H_CLIENT_HELLO |          \
	  KSSL_CONN_M_H_SERVER_HELLO | KSSL_CONN_M_H_CERTIFICATE |            \
	  KSSL_CONN_M_H_SERVER_KEY_EXCHANGE |                                 \
	  KSSL_CONN_M_H_CERTIFICATE_REQUEST |                                 \
	  KSSL_CONN_M_H_SERVER_HELLO_DONE |                                   \
	  KSSL_CONN_M_H_CERTIFICATE_VERIFY |                                  \
	  KSSL_CONN_M_H_CLIENT_KEY_EXCHANGE |                                 \
	  KSSL_CONN_M_H_FINISHED )


u32 kssl_message_mask_check(const kssl_record_t *cr);

void kssl_message_mask_update_out(kssl_record_t *cr);

void kssl_message_update_mask_in(kssl_record_t *cr);

#endif /* __KSSLD_MESSAGE_MASK_H */
