/**********************************************************************
 * record_list.h                                            August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _KSSL_CONN_RECORD_LIST_H
#define _KSSL_CONN_RECORD_LIST_H

#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/list.h>
#include <linux/version.h>

extern struct list_head kssl_message_in_list;
extern struct list_head kssl_record_in_list;
extern struct list_head kssl_record_out_list;

void kssl_record_list_clear(struct list_head *list);

void kssl_record_list_clear_conn(struct list_head *list, kssl_conn_t *conn);

#endif /* _KSSL_CONN_RECORD_LIST_H */

