/*!
 * @file l7vs_dest.h
 * @brief RealServer component.
 * @brief 
 *
 *
 */

#ifndef	L7VS_DEST_H
#define	L7VS_DEST_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "l7vs_conn.h"

//
// ! real-server datatype
//
//
struct	l7vs_dest{
	struct sockaddr_in	addr;		//! sockaddr
	int			weight;		//! schedule weight use
	int			nactive;	//! nactive
	int			ninact;		//! ninactive
};

//
// ! real-server datatype, external representation
//
//
struct	l7vs_dest_arg{
	struct sockaddr_in	addr;
	int			weight;
	int			nactive;
	int			ninact;
};

//
// functions.
//
extern	struct l7vs_dest*	l7vs_dest_create( struct sockaddr_in*, int );
extern	void			l7vs_dest_destroy( struct l7vs_dest* );
extern	void			l7vs_dest_to_arg( struct l7vs_dest*, struct l7vs_dest_arg* );

#endif	//L7VS_DEST_H
