/**********************************************************************
 * l7vs_module.h                                               May 2007 
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_MODULE_H
#define	L7VS_MODULE_H

#include <stdint.h>
#include <glib.h>
#include "l7vs.h"
#include "l7vs_service.h"

struct	l7vs_conn;
struct	l7vs_service;
struct	l7vs_service_arg;
struct	l7vs_dest;

struct	l7vs_protomod{
	void*	handle;
	char	modname[L7VS_MODNAME_LEN+1];
	int	refcnt;

	//member functions
	int   ( *create )( void*, uint32_t );
	int   ( *compare )( uint32_t, uint32_t );
	int   ( *match_cldata )( struct l7vs_service*, struct l7vs_conn*, char*, size_t*, struct l7vs_dest**, int* );
	int   ( *analyze_rsdata )( struct l7vs_service*, struct l7vs_conn*, char*, size_t* );
	int   ( *destroy )( uint32_t );
	void  ( *fini )();
	void* ( *create_sa )( struct l7vs_service_arg* );
	int   ( *service_arg )( struct l7vs_service_arg_multi*, uint32_t );
	int   ( *parse )( void*, int, char** );
	void  ( *destroy_sa )( void** );
	int   ( *initialize )( struct l7vs_service*, struct l7vs_conn*, char*, size_t, struct l7vs_dest** );
	int   ( *finalize )( struct l7vs_service*, struct l7vs_conn*, char*, size_t, struct l7vs_dest**, int );
};

extern char	l7vs_module_path[];

//
// functions
//

extern struct l7vs_protomod*	l7vs_protomod_get( char* );
extern void			l7vs_protomod_put( struct l7vs_protomod* );
extern struct l7vs_protomod*	l7vs_protomod_lookup( char* );
extern	int			l7vs_module_init( char* );
extern	void			l7vs_module_fini();
extern	void*			l7vs_module_load( char*, char* );
extern	void			l7vs_module_unload( void* );
extern	void			l7vs_module_register( GList**, void* );
extern	void			l7vs_module_remove( GList**, void* );
extern	void*			l7vs_module_lookup( GList*, void*, GCompareFunc );

#endif	//L7VS_MODULE_H
