/*!
 * @file 	l7vs.h
 * @brief	UltraMonkey-L7 main header
 * @author	nakai norihisa
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef L7VS_H
#define L7VS_H

#define L7VS_VERSION_STRING             "1.0.1"         /*! by autoconf */

/*!
 * default module path
 */
#ifndef L7VS_MODULE_PATH
        #define L7VS_MODULE_PATH        "."
#endif  //L7VS_MODULE_PATH

#define L7VS_MODNAME_LEN                (16)		/*!	Module name length*/
#define L7VS_PROTOMOD_MAX_BUFSIZE       (256)		/*! protocol module max buffer size */
#define L7VS_PROTOMOD_MAX_ADD_BUFSIZE   (256)		/*! protocol module max addbuffer size */
#define L7VS_PROTOMOD_MAX_SERVICE_ARG   (256)		/*! protocol module max service argument size */

extern char l7vs_module_path[];						/*! protocol module path */

#endif /* L7VS_H */
