 /*
 * @file        sched_lc.c
 * @brief       Least-Connection Scheduling Module for UltraMonkey-L7
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <limits.h>
#include "vanessa_logger.h"
#include "l7vs_dest.h"
#include "l7vs_service.h"
#include "l7vs_conn.h"
#include "l7vs_sched.h"

//
// this scheduler don't use srv->sched_data
//
//

static void fini(void);
static struct l7vs_dest *l7vs_sched_lc_schedule(struct l7vs_service *srv,
                                                struct l7vs_conn *conn);

static struct l7vs_scheduler sched_lc_scheduler = {
        NULL,
        "lc",
        0,
        l7vs_sched_lc_schedule,         /* schedule function */
        NULL,                           /* bind function */
        NULL,                           /* unbind function */
        fini                            /* fini function */
};

struct l7vs_scheduler *
init(void *handle)
{
        sched_lc_scheduler.handle = handle;
        return &sched_lc_scheduler;
}

static void
fini(void)
{
}

static struct l7vs_dest *
l7vs_sched_lc_schedule(struct l7vs_service *srv,
                       struct l7vs_conn *conn)
{
	int nactive = INT_MAX;
	GList* active_dest_list = NULL;
	GList* ptr = NULL;
	struct l7vs_dest* rect = NULL;
	struct l7vs_dest* target = NULL;
	if( !srv ) return NULL;


	//create active list
	for( ptr = g_list_first( srv->dest_list ); ptr; ptr = g_list_next(ptr) ){
		struct l7vs_dest* dest = (struct l7vs_dest*)ptr->data;
		if(  dest->weight > 0 ) active_dest_list = g_list_append( active_dest_list, dest );
	}

	//active dest don't have
	if( !active_dest_list ) return NULL;

	for( ptr = g_list_first( active_dest_list ); ptr; ptr = g_list_next( ptr ) ){
		target = ( struct l7vs_dest* ) ptr->data;
		if( nactive > target->nactive ){
			rect = target;
			nactive = target->nactive;
		}	
	}
	g_list_free( active_dest_list );
	return target;
}
