 /*!
 * @file	l7vs_config.h
 * @brief	configulation module header file.
 * @auther	nakai norihisa
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_CONFIG_H
#define	L7VS_CONFIG_H

#include "logger_wrapper.h"
#include "parameter_wrapper.h"
#include "l7vs_replication.h"
#include "l7vs_snmpbridge.h"

#include "l7vs_dest.h"


/*!
 *	config socket file path
 */
#ifndef L7VS_CONFIG_SOCK_PATH
        #define L7VS_CONFIG_SOCK_PATH   "/var/run/l7vs"
#endif
#define L7VS_CONFIG_SOCKNAME            L7VS_CONFIG_SOCK_PATH "/l7vs"



/*!
 *	configulation module error type
 *
 */
enum	l7vs_config_err_type{
	L7VS_CONFIG_NOERR		= 0,		/*! command error none. default value */
	L7VS_CONFIG_ERR_INVALID_COMMAND = 1,		/*! command is invalid		*/
	L7VS_CONFIG_ERR_NOMEM		= 2,		/*! don't allocate memory	*/
	L7VS_CONFIG_ERR_VS_EXISTS	= 3,		/*! virtual service exists	*/
	L7VS_CONFIG_ERR_RS_EXISTS	= 4,		/*! real server exists 		*/
	L7VS_CONFIG_ERR_NOVS		= 5,		/*! no virtual service 		*/
	L7VS_CONFIG_ERR_NORS		= 6,		/*! no real server 		*/
	L7VS_CONFIG_ERR_NOSCHED		= 7,		/*! no schedule module		*/
	L7VS_CONFIG_ERR_NOSOCK		= 8,		/*! no socket			*/
	L7VS_CONFIG_ERR_QOSSET		= 9,		/*! set QoS threashold failure	*/
	L7VS_CONFIG_ERR_SORRYSET	= 10,		/*! modify Sorry-Server Values failure	*/
	L7VS_CONFIG_ERR_SENDMSG		= 11,		/*! send message failure	*/
	L7VS_CONFIG_ERR_MAXVS_EXISTS	= 12		/*! max service instance is exists */
};

/*!
 * configulation command type
 *
 */
enum	l7vs_config_command{
	L7VS_CONFIG_LIST_VS,				/*! virtual service list up 	*/
	L7VS_CONFIG_LIST_RS,				/*! real server list up		*/
	L7VS_CONFIG_ADD_VS,				/*! virtual service add		*/
	L7VS_CONFIG_ADD_RS,				/*! real server add 		*/
	L7VS_CONFIG_DEL_VS,				/*! virtual service delete	*/
	L7VS_CONFIG_DEL_RS,				/*! real server delete		*/
	L7VS_CONFIG_EDIT_VS,				/*! virtual service edit	*/
	L7VS_CONFIG_EDIT_RS,				/*! real server edit		*/
	L7VS_CONFIG_FLUSH_VS,				/*! virtual service flush	*/
	L7VS_CONFIG_GET_REPLICATION_INFO,		/*! get replication information 	*/
	L7VS_CONFIG_REPLICATION,			/*! modify replication information 	*/
	L7VS_CONFIG_GET_LOG_INFO,			/*! get log information			*/
	L7VS_CONFIG_SET_LOG_LEVEL,			/*! modify log information		*/
	L7VS_CONFIG_SET_LOG_LEVEL_ALL,			/*! modify log information		*/
	L7VS_CONFIG_GET_SNMP_LOG_INFO,			/*! get SNMP information		*/
	L7VS_CONFIG_GET_SNMP_CONNECT_STATUS,		/*! get SNMP information		*/
	L7VS_CONFIG_SET_SNMP_LOG_LEVEL,			/*! modify SNMP information		*/
	L7VS_CONFIG_SET_SNMP_LOG_LEVEL_ALL,		/*! get SNMP information(connect status)*/
	L7VS_CONFIG_PARAMETER,				/*! modify parameter			*/
	L7VS_CONFIG_NONE				/*! no config				*/
};


/*!
 *	config request for virtual service
 */
struct	l7vs_config_req_list_vs{
	enum l7vs_config_command	cmd;		/*! request command		*/
};

/*!
 *	config request for real server 
 */
struct	l7vs_config_req_list_rs{
	enum l7vs_config_command	cmd;		/*! request command		*/
	// service_arg follows
};

/*!
 *	config request for operation virtual service
 */
struct	l7vs_config_req_operate_vs{
	enum l7vs_config_command	cmd;		/*! request command		*/
	// service_arg follows
};

/*!
 *	config request for operation 
 */
struct	l7vs_config_req_operate_rs{
	enum l7vs_config_command	cmd;		/*! request comand		*/
	struct l7vs_dest_arg		darg;		/*! real server data		*/
	//service_arg	follows
};

/*!
 *	config request for virtual service flash
 */
struct	l7vs_config_req_flush_vs{
	enum l7vs_config_command	cmd;		/*!	request command		*/
};	

/*!
 *      config message for replication kind
 */
enum	REPLICATION_KIND_TAG{
	L7VS_CONFIG_REPLICATION_DUMP=0,			/*! replication dump  */
	L7VS_CONFIG_REPLICATION_START,			/*! raplication start */
	L7VS_CONFIG_REPLICATION_STOP,			/*! replication stop  */
	L7VS_CONFIG_REPLICATION_COMPULSORILY		/*! compulsion replication */
};

/*!
 *      config message for replication
 */
struct l7vs_config_msg_replication{
	enum l7vs_config_command	cmd;		/*! request command      */
	int  code;					/*! error code number    */
	enum REPLICATION_KIND_TAG kind;			/*! replication action   */
	enum REPLICATION_MODE_TAG replication_mode;	/*! replication mode     */
};


/*!
 *      config message for log
 */
struct l7vs_config_msg_log{
	enum l7vs_config_command	cmd;		/* request command                       */
	int  code;					/* error code number                     */
	LOG_CATEGORY_TAG  kind;				/* kind of log action                    */
	LOG_LEVEL_TAG     vsd_log_level;		/* log category of network               */
};

/*!
 *      config message for SNMP
 */
struct l7vs_config_msg_snmp{
	enum l7vs_config_command	cmd;		/* request command                      */
	int  code;					/* error code number                    */
	enum LOG_CATEGORY_TAG kind;			/* kind of action			*/
	enum LOG_LEVEL_TAG  snmp_log_level;		/* SNMP Loglevel			*/
	int  connection_status;				/* connection information		*/
};

/*!
 *      config message for parameter
 */
struct l7vs_config_msg_parameter{
	enum l7vs_config_command	cmd;		/* request command                       */
	int  code;					/* error code number                     */
	enum PARAMETER_COMPONENT_TAG  category;		/* parameter category			 */
};

/*!
 *	config request union.
 *	this union is extend class like.
 *	but, memory management is not.
 */
union	l7vs_config_req{
	enum l7vs_config_command		cmd;
	struct l7vs_config_req_list_vs		list_vs; 
	struct l7vs_config_req_list_rs		list_rs;
	struct l7vs_config_req_operate_vs	operate_vs;
	struct l7vs_config_req_operate_rs	operate_rs;
	struct l7vs_config_req_flush_vs		flush_vs;
	struct l7vs_config_msg_replication      msg_replication;
	struct l7vs_config_msg_log              msg_log;
	struct l7vs_config_msg_snmp             msg_snmp;
	struct l7vs_config_msg_parameter        msg_parameter;
	char	_buf[2048];	
};


/*!
 *	config response list virtual service
 */
struct	l7vs_config_rsp_list_vs{
	enum l7vs_config_command	cmd;		/*! response command		*/
	int				code;		/*! virtual service code	*/
	int				num;		/*! number			*/
	// number of "num" l7vs_service_arg follow
};

/*!
 *	config response list real server
 */
struct	l7vs_config_rsp_list_rs{
	enum l7vs_config_command	cmd;		/*! response command		*/
	int				code;		/*! real server code		*/
	int				num;		/*! number			*/
	//number of "num" l7vs_dest_args_follow
};

/*!
 *	config response operation virual service
 */
struct	l7vs_config_rsp_operate_vs {
	enum l7vs_config_command	cmd;		/*! response commnad		*/
	int				code;		/*! response code		*/
};

/*!
 *	config response operation real server
 */
struct	l7vs_config_rsp_operate_rs {
	enum l7vs_config_command	cmd;		/*! response command		*/
	int				code;		/*! response code		*/
};

/*!
 *	config response flush virtual service
 */
struct	l7vs_config_rsp_flush_vs{
	enum l7vs_config_command	cmd;		/*! response command		*/
	int				code;		/*! response code		*/
};

 /*!
  *	config unknown command response
  */
struct	l7vs_config_rsp_unknown_cmd{
	enum l7vs_config_command	cmd;		/*! response command		*/
	int				code;		/*! response code		*/
};

//
// functions
//

/*! l7vs_config_init
 *	configration module initialize function.
 *	@return		success return is 0, else error code
 */
extern	int	l7vs_config_init();

/*!
 *	l7vs_config_fini()
 *	configuration module finalize function.
 */
extern	void	l7vs_config_fini();

#endif	//L7VS_CONFIG_H
