/*
 * @file  module_sslid_hash_map.h
 * @brief sslid hashmap container.
 * @brief this module provide session persistence by SSL session ID.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2008  NTT COMWARE Corporation.
 * Copyright (C) 2009  Shinya TAKEBAYASHI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __MODULE_SSLID_HASH_MAP_H_5D6935E5_0C3D_447D_8E13_BEFC7619F621__
#define __MODULE_SSLID_HASH_MAP_H_5D6935E5_0C3D_447D_8E13_BEFC7619F621__


typedef std::tr1::unordered_map<std::string, struct l7vs_dest> IDMAP;
typedef std::list<IDMAP::iterator> IDLIST;


class CSSLIDMap
{
 public: 
  CSSLIDMap();
  ~CSSLIDMap();

  void add(const std::string, struct l7vs_dest);
  bool search(const std::string, struct l7vs_dest**);

  void allocate(unsigned int);
  void destroy(void);
  
  void *getIDMAP(void);
  void *getIDLIST(void);
  int getLISTSIZE(void);
  void setPointer(const void *, const void *, unsigned int);
  void construct_sessionlist(struct l7vs_sslid_service*);  
  void rebuild_sessionlist(struct l7vs_sslid_service*);  

 private:
  IDMAP *m;
  IDLIST *l;
  unsigned int listsize;
};


#endif // __MODULE_SSLID_HASH_MAP_H_5D6935E5_0C3D_447D_8E13_BEFC7619F621__
