#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# Usage: formatdb.sh [-f]

# $Id: formatdb.sh,v 1.8 2004/06/17 05:27:43 taru Exp $

set -e

eval `ultrapossum-config get MODULEDIR DIRECTORY CONFSTATUS CHROOTDIRECTORY`

if test `$MODULEDIR/server/startup status` = "running"; then
  if test "x$1" = "x-f"; then
    echo -n "W: UltraPossum server is running... Stopping... " 1>&2
    status=started
    $MODULEDIR/server/startup stop 1>&2
    echo "" 1>&2
  else
    echo "E: UltraPossum server is running" 1>&2
    exit 1
  fi
fi

/bin/rm -rf $DIRECTORY $CONFSTATUS $CHROOTDIRECTORY$DIRECTORY
update-ultrapossum configure

if test "x$status" = "xstarted"; then
    $MODULEDIR/server/startup start 1>&2
    echo "UltraPossum started" 1>&2
fi

