#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: ha.cf.sh,v 1.4 2004/09/22 12:31:11 taru Exp $

set -e

eval `ultrapossum-config init`

# System level default
#logfile="/var/log/ha-log"
#logfacility="local0"
#keepalive="2"
#deadtime="10"
#initdead="120"
#hopfudge="1"
#serial="/dev/ttyS0"
#baud="19200"
#udpport="694"
#udp="eth0"
#mcast="eth0 225.0.0.1 694 1 1"
#watchdog="/dev/watchdog"

if test -f $SYSCONFDIR/default.cf; then
  source_shell $SYSCONFDIR/default.cf
fi

if test -f default.cf; then
  source_shell default.cf
fi

SUPPORTED_DIRECTIVE="logfile logfacility keepalive deadtime initdead hopfudge serial baud udpport udp mcast watchdog nice_failback"
HACFIN=$TEMPLATEDIR/ha.cf.in
if test -f "ha.cf.in"; then
  HACFIN=ha.cf.in
fi

tmp=`tempfile`
tmp2=`tempfile`
trap "/bin/rm -f $tmp $tmp2; eval `ultrapossum-config term`" 0

cp $HACFIN $tmp
for d in $SUPPORTED_DIRECTIVE
do
  val=$(eval "echo \$$d")
  if test "x$val" != "x"; then
    sed -e "/#$d	/ a\\" -e "$d	$val" < $tmp > $tmp2
    cp $tmp2 $tmp
  fi
done
cat $tmp
