#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: slapd.sh,v 1.22 2004/10/26 13:31:44 taru Exp $

set -e

eval `ultrapossum-config init`

tmp=`tempfile`
trap "/bin/rm -f $tmp; eval `ultrapossum-config term`" 0

common() {

  INDEXES_EQ="objectClass"
  if test "x$SLAPD_PROVIDES_SYNCBACKUP" != "x"; then
    INDEXES_EQ="$INDEXES_EQ,contextCSN,entryUUID,structuralObjectClass,entryCSN"
  fi
  ## FIXME: handle database specific grammer?
  ## TODO: choose apps
  for cf in `/bin/ls $APPSDIR`
  do
    source_shell $APPSDIR/$cf
    if test -f $APPSCONFDIR/$cf.cf; then
      source_shell $APPSCONFDIR/$cf.cf
    fi
    for i in $indexes_eq
    do
      if ! echo "$INDEXES_EQ" | grep $i > /dev/null; then
        INDEXES_EQ="$INDEXES_EQ
$i"
      fi
    done

    for i in $indexes_sub
    do
      if test "x$INDEXES_SUB" = "x"; then
        INDEXES_SUB=$i
      else
        if ! echo "$INDEXES_SUB" | grep $i > /dev/null; then
          INDEXES_SUB="$INDEXES_SUB
$i"
        fi
      fi
    done

  done

  INDEXES_EQ=`echo -n "$INDEXES_EQ" | tr '\n' ','`
  INDEXES_SUB=`echo -n "$INDEXES_SUB" | tr '\n' ','`
  test -z "$INDEXES_EQ"  || INDEXES="index $INDEXES_EQ eq"
  test -z "$INDEXES_SUB" || INDEXES="$INDEXES\\
index $INDEXES_SUB sub"

  SLAPROOTPW_ESCAPE=`echo $SLAPROOTPW | sed 's!/!\\\\/!g'`
  sed -e "s/#SUFFIX#/$SUFFIX/" -e "s/#ROOTDN#/$ROOTDN/" \
  	-e "s/#SLAPROOTPW#/$SLAPROOTPW_ESCAPE/" -e "s!#DIRECTORY#!$DIRECTORY!" \
  	-e "s/#DBCACHESIZE#/$DBCACHESIZE/" -e "s/#APPLICATION#/$APPLICATION/" \
  	-e "s/#UPDATEDN#/$UPDATEDN/" -e "/#INDEXES#/ c\\" -e "$INDEXES" \
  	-e "s!#REPLOGFILE#!$REPLOGFILE!" -e "s!#CACHESIZE#!$CACHESIZE!"
}

master() {
  common
  # FIXME: little ad-hoc
  slurpds="$SLURPDSLAVES"
  if test "x$SYNCBACKUPS" = "x"; then
    slurpds="$SLURPDSLAVES $MASTER"
  fi
  for slave in $slurpds
  do
    if test "x$HOST" != "x$slave"; then
      echo "replica host=$slave:$REPLICALISTENPORT"
      if test "x$REPLICASTARTTLS" != "xno"; then
        echo "	tls=$REPLICASTARTTLS"
      fi
      case "x$APPDNMODE" in
        xSASL/Digest-MD5)
          authcid="`echo $UPDATEDN | cut -d, -f1 | cut -d= -f2`@$PACKAGE"
          echo "	authcid=\"$authcid\""
          echo "	bindmethod=sasl"
          echo "	saslmech=DIGEST-MD5"
          echo "	credentials=$CREDENTIALS"
        ;;
        x*)
          echo "	binddn=\"$UPDATEDN\""
          echo "	bindmethod=simple"
          echo "	credentials=$CREDENTIALS"
        ;;
      esac
      echo ""
    fi
  done
  if test "x$ROOTDN" = "x$UPDATEDN"; then
    echo "# Replication"
    echo "updatedn \"$UPDATEDN\""
    if test "x$UPDATEREF" != "x"; then
      echo "updateref $UPDATEREF"
    fi
  fi
  if test "x$SYNCBACKUPS" != "x"; then
    echo "syncdn $UPDATEDN"
    if test "x$WEAKSYNC" != "x"; then
      echo "weaksync on"
    fi
    for slave in $SYNCBACKUPS
    do
      if test "x$HOST" != "x$slave"; then
        echo "replica host=$slave:$REPLICALISTENPORT"
	echo "	syncid=$slave"
        if test "x$REPLICASTARTTLS" != "xno"; then
          echo "	tls=$REPLICASTARTTLS"
        fi
        case "x$APPDNMODE" in
          xSASL/Digest-MD5)
            authcid="`echo $UPDATEDN | cut -d, -f1 | cut -d= -f2`@$PACKAGE"
            echo "	authcid=\"$authcid\""
            echo "	bindmethod=sasl"
            echo "	saslmech=DIGEST-MD5"
            echo "	credentials=$CREDENTIALS"
          ;;
          x*)
            echo "	binddn=\"$UPDATEDN\""
            echo "	bindmethod=simple"
            echo "	credentials=$CREDENTIALS"
          ;;
        esac
        echo ""
      fi
    done
  fi
}

slave() {
  common
  if include "$HOST" "$SYNCREPLS"; then
    echo "syncrepl rid=$SYNCREPLRID"
    echo "	provider=$UPDATEREF"
    echo "	type=$SYNCREPLTYPE"
    if test "x$REPLICASTARTTLS" != "xno"; then
      echo "	starttls=$REPLICASTARTTLS"
    fi
    if test "x$SYNCREPLTYPE" = "xrefreshOnly"; then
      echo "	interval=$SYNCREPLINTERVAL"
    else
      echo "	retry=$SYNCREPLRETRY"
    fi
    echo "	searchbase=$SUFFIX"
    echo "	updatedn=$UPDATEDN"
    case "x$APPDNMODE" in
      xSASL/Digest-MD5)
        authcid="`echo $UPDATEDN | cut -d, -f1 | cut -d= -f2`@$PACKAGE"
        echo "	authcid=\"$authcid\""
        echo "	bindmethod=sasl"
        echo "	saslmech=DIGEST-MD5"
        echo "	credentials=$CREDENTIALS"
      ;;
      x*)
        echo "	binddn=\"$UPDATEDN\""
        echo "	bindmethod=simple"
        echo "	credentials=$CREDENTIALS"
      ;;
    esac
    echo ""
  fi
  if include "$HOST" "$SYNCBACKUPS"; then
    # set updatedn directive for syncbackup bug
    echo "updatedn \"$UPDATEDN\""
    echo "syncbackup syncid=$HOST"
    echo "	provider=$UPDATEREF"
    case "x$APPDNMODE" in
      xSASL/Digest-MD5)
        authcid="`echo $UPDATEDN | cut -d, -f1 | cut -d= -f2`@$PACKAGE"
        echo "	authcid=\"$authcid\""
        echo "	bindmethod=sasl"
        echo "	saslmech=DIGEST-MD5"
        echo "	credentials=$CREDENTIALS"
      ;;
      x*)
        echo "	binddn=\"$UPDATEDN\""
        echo "	bindmethod=simple"
        echo "	credentials=$CREDENTIALS"
      ;;
    esac
    echo "	checkinterval=10"
    if test "x$REPLICASTARTTLS" != "xno"; then
      echo "	starttls=$REPLICASTARTTLS"
    fi
    echo ""
  fi
  if test "x$SLAVES$ANOTHER_MASTER" != "x" || include "$HOST" "$SYNCBACKUPS"; then
    echo "# Replication"

    # updatedn directive is used only when si_updatedn not used
    if ! include "$HOST" "$SYNCREPLS $SYNCBACKUPS" ; then
      echo "updatedn \"$UPDATEDN\""
    fi

    if test "x$UPDATEREF" != "x"; then
      echo "updateref $UPDATEREF"
    fi

  fi
}

if test "x$2" = "x"; then
  echo "Usage: $0 <slapd.conf.in> <master|slave>"
  exit 1
fi

if test "x$REPLICASTARTTLS" = "x"; then
  REPLICASTARTTLS="no"
fi

cat $1 | $2

