#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

if test "x$SLAPD_VERSION" = "2.0"; then
  echo "E: can't backup when slapd $SLAPD_VERSION is running" 1>&2
  exit 1
fi

install -d $BACKUPDIR

backup=$BACKUPDIR/$SUFFIX-`date +%Y%m%d`.ldif.gz

if test -f $backup; then
  echo "W: $backup already exist" 1>&2
else
  echo -n "Backing up $SUFFIX... "
  touch $backup
  chmod 600 $backup
  slapcat -b $SUFFIX | gzip -c > $backup
  echo "done"
fi

