#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

set -e

eval `ultrapossum-config init` 2> /dev/null

if test -d "$DIRECTORY"; then
  echo "W: $DIRECTORY already exist" 1>&2
  exit 0
fi

install -d $DIRECTORY > /dev/null

if test "x$HOST" != "x$MASTER" && include "$HOST" "$SYNCBACKUPS"; then
  exit 0
fi

tmp=`tempfile`
trap "/bin/rm -f $tmp; eval `ultrapossum-config term`" 0

if test "x$HOST" = "x$MASTER"; then
 ldiffile=$tmp
 cat $ULTRAPOSSUMLDIF > $tmp
 echo "" >> $tmp
 cat $APPSLDIF >> $tmp
else
 ldiffile=$DIRECTORY/$HOST.ldif
 if ! test -s $ldiffile; then
   if ssh $MASTER "cat $DIRECTORY/$HOST.ldif && cp /dev/null $DIRECTORY/$HOST.ldif" > $ldiffile; then
     if ! test -s $ldiffile; then
       echo "E: Initial LDIF file already fetched." 1>&2
       /bin/rm -rf $DIRECTORY
       exit 1
     fi
   else
     echo "E: fail to fetch the initial directory from $MASTER" 1>&2
     /bin/rm -rf $DIRECTORY
     exit 1
   fi
 fi
fi

echo -n "Creating Initial Directory in $DIRECTORY... " 1>&2
if slapadd -b $SUFFIX -l $ldiffile -f $SLAPDCONF; then
  touch $DIRECTORY/ultrapossum-environ
  chmod 600 $DIRECTORY/ultrapossum-environ
  getconfig > $DIRECTORY/ultrapossum-environ
  echo "done" 1>&2
else
  /bin/rm -rf $DIRECTORY
  echo "failed" 1>&2
  exit 1
fi
