#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

if test `$MODULEDIR/server/startup status` = "running"; then
  stat="running"
  $MODULEDIR/server/startup stop
fi

/bin/rm -rf $DIRECTORY
$MODULEDIR/server/createdb.sh

if test "x$MASTER" = "x$HOST"; then
 for host in $SLURPDSLAVES
 do
   if ! test -f "$DIRECTORY/$host.ldif"; then
     echo -n "Creating $host LDIF... " 1>&2
     touch $DIRECTORY/$host.ldifT
     chmod 600 $DIRECTORY/$host.ldifT
     slapcat -b $SUFFIX -f $SLAPDMASTERCONF >  $DIRECTORY/$host.ldifT
     mv $DIRECTORY/$host.ldifT $DIRECTORY/$host.ldif
     echo "done" 1>&2
    fi
  done

#  for h in $BACKUP $SLAVES
#  do
#    ssh -t $h "
#  eval \`ultrapossum-config init\`
#  ULTRAPOSSUM_PROJECT=$ULTRAPOSSUM_PROJECT \$MODULEDIR/server/formatdb.sh
#  "
#  done

fi

if test "x$stat" = "xrunning"; then
  $MODULEDIR/server/startup start
fi

