/* cdedit2 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_define.h"
#include "cd_menu.h"
#include "cd_io.h"

/*
 * cd_menu_file_new
 */
void cd_menu_file_new()
{
  cd_io_filename_init();

  cd_node_init();
  cd_arc_init();
  
  cd_canvas_white();
  cd_canvas_update_all();
}

/*
 * cd_menu_file_load
 */
void cd_menu_file_load()
{
  cd_node_init();
  cd_arc_init();

  cd_io_dialog_open();

  if(!cd_io_load()) {
    g_print(CD_IO_MESSAGE4);
    return;
  }

  cd_canvas_size_update();
  cd_canvas_white();
  cd_control_draw_all();
  cd_canvas_update_all();
}

/*
 * cd_menu_file_save
 */
void cd_menu_file_save()
{
  cd_control_save();
}

/*
 * cd_menu_file_save_as
 */
void cd_menu_file_save_as()
{
  cd_io_dialog_open();
  cd_io_save();
}

/*
 * cd_menu_file_export_jpg
 */
void cd_menu_file_export_jpg()
{
  cd_io_export(JPG);
}

/*
 * cd_menu_file_export_eps
 */
void cd_menu_file_export_eps()
{
  cd_io_export(EPS);
}

/*
 * cd_menu_file_quit
 */
void cd_menu_file_quit()
{
  gtk_exit(0);
}

/*
 * File Menu
 */
static GtkItemFactoryEntry cd_menu_file[] = {
  { CD_MENU_FILE,            NULL,         NULL, 0, CD_MENU_BRANCH },
  { CD_MENU_FILE_NEW,        "<control>N", cd_menu_file_new,     0, NULL },
  { CD_MENU_FILE_OPEN,       "<control>O", cd_menu_file_load,    0, NULL },
  { CD_MENU_FILE_SAVE,       "<control>S", cd_menu_file_save,    0, NULL },
  { CD_MENU_FILE_SAVE_AS,    NULL,         cd_menu_file_save_as, 0, NULL },
  { CD_MENU_FILE_SEPARATOR,  NULL,         NULL, 0, CD_MENU_SEPARATOR },
  { CD_MENU_FILE_EXPORT,     NULL,         NULL, 0, CD_MENU_BRANCH },
  { CD_MENU_FILE_EXPORT_JPG, "<control>J", cd_menu_file_export_jpg, 0, NULL },
  { CD_MENU_FILE_EXPORT_EPS, "<control>E", cd_menu_file_export_eps, 0, NULL },
  { CD_MENU_FILE_SEPARATOR,  NULL,         NULL, 0, CD_MENU_SEPARATOR },
  { CD_MENU_FILE_QUIT,       "<control>Q", cd_menu_file_quit,    0, NULL },
};

/*
 * cd_menu_edit_delete
 */
void cd_menu_edit_delete()
{
  cd_control_delete();

  cd_canvas_white();
  cd_control_draw_all();
  cd_canvas_update_all();
}

/*
 * Edit Menu
 */
static GtkItemFactoryEntry cd_menu_edit[] = {
  { CD_MENU_EDIT,        NULL,         NULL,               0, CD_MENU_BRANCH },
  { CD_MENU_EDIT_DELETE, "<control>D", cd_menu_edit_delete, 0, NULL },
};

/*
 * cd_menu_tool_set
 */
void cd_menu_tool_set()
{
  cd_control_tool_set_dialog_open();
}

/*
 * cd_menu_tool_refresh
 */
void cd_menu_tool_refresh()
{
  cd_canvas_white();
  cd_control_draw_all();
  cd_canvas_update_all();
}

/*
 * Tool Menu
 */
static GtkItemFactoryEntry cd_menu_tool[] = {
  { CD_MENU_TOOL,         NULL,         NULL,              0, CD_MENU_BRANCH },
  { CD_MENU_TOOL_SET,     "<control>T", cd_menu_tool_set,     0, NULL },
  { CD_MENU_TOOL_REFRESH, "<control>R", cd_menu_tool_refresh, 0, NULL },
};

/*
 * cd_menubar_new
 */
void cd_menubar_new(GtkWidget *window, GtkWidget *vbox)
{
  int menu_file_num = sizeof(cd_menu_file) / sizeof(cd_menu_file[0]);
  int menu_edit_num = sizeof(cd_menu_edit) / sizeof(cd_menu_edit[0]);
  int menu_tool_num = sizeof(cd_menu_tool) / sizeof(cd_menu_tool[0]);

  GtkWidget *menubar;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel;
  GtkWidget *handle;

  handle = gtk_handle_box_new();
  accel = gtk_accel_group_new();

  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel);

  gtk_item_factory_create_items
    (item_factory, menu_file_num, cd_menu_file, NULL);
  gtk_item_factory_create_items
    (item_factory, menu_edit_num, cd_menu_edit, NULL);
  gtk_item_factory_create_items
    (item_factory, menu_tool_num, cd_menu_tool, NULL);

  gtk_accel_group_attach(accel, GTK_OBJECT(window));

  menubar = gtk_item_factory_get_widget(item_factory, "<main>");

  gtk_widget_show(menubar);

  gtk_container_add(GTK_CONTAINER(handle), GTK_WIDGET(menubar));
  gtk_box_pack_start(GTK_BOX(vbox), handle, FALSE, FALSE, 0);
  gtk_widget_show(handle);
}
