/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_pg_util.h"

/*
 * cd_pg_util_create_table
 */
void cd_pg_util_create_table(PgDialog *pd)
{
  int i, j, attr_len;
  PgAttribute *attr;
  GString *sql;
  
  char *pghost, *pgport, *pgoptions, *pgtty, *dbName;
  PGconn *conn;
  PGresult *res;

  attr_len = g_list_length(pd->ni->attributes);
  if(attr_len <= 0){
    cd_util_message(ERR_TABLE);
    return;
  }

  //dbName = gtk_entry_get_text((GtkEntry*)pd->cp.entrys[0]);
  dbName = ((PgData*)(pd->ni->data))->db;

  if(strlen(dbName) <= 0){
    cd_util_message(ERR_DB);
    return;
  }

  sql = g_string_new("create table ");
  sql = g_string_append(sql, pd->ni->name);
  sql = g_string_append(sql, " ( ");

  for(j=0; j<g_list_length(pd->ni->attributes); j++){
    attr = g_list_nth_data(pd->ni->attributes, j);
    sql = g_string_append(sql, attr->name);
    switch(attr->type){
    case pg_text:
      sql = g_string_append(sql, " text ");
      break;
    case pg_varchar:
      sql = g_string_append(sql, " varchar ");
      break;
    case pg_int4:
      sql = g_string_append(sql, " int4 ");
      break;
    case pg_int8:
      sql = g_string_append(sql, " int8 ");
      break;
    case pg_serial:
      sql = g_string_append(sql, " serial ");
      break;
    case pg_datetime:
      sql = g_string_append(sql, " datetime ");
      break;
    case pg_date:
      sql = g_string_append(sql, " date ");
      break;
    case pg_time:
      sql = g_string_append(sql, " time ");
      break;
    }
    if(j < attr_len-1)
      sql = g_string_append(sql, ", ");
  }

  sql = g_string_append(sql, ")");

  pghost = NULL;
  pgport = NULL;
  pgtty = NULL;
  pgoptions = NULL;
  
  conn = PQsetdb(pghost, pgport, pgoptions, pgtty, dbName);
    
  if(PQstatus(conn) == CONNECTION_BAD){
    cd_util_message(ERR_CON);
    PQfinish(conn);
    g_string_free(sql, TRUE);
    return;
  }

  res = PQexec(conn, "BEGIN");
  if(PQresultStatus(res) != PGRES_COMMAND_OK){
    cd_util_message("BEGIN command failed");
    PQclear(res);
    g_string_free(sql, TRUE);

    PQfinish(conn);
    return;
  }
  PQclear(res);

  res = PQexec(conn, sql->str);
  if(PQresultStatus(res) != PGRES_COMMAND_OK){
    cd_util_message(ERR_SQL);
    PQclear(res);
    g_string_free(sql, TRUE);

    PQfinish(conn);
    return;
  }
  PQclear(res);

  res = PQexec(conn, "COMMIT");
  PQclear(res);

  PQfinish(conn);
  g_string_free(sql, TRUE);
}

/*
 * cd_pg_util_select_table
 */
void cd_pg_util_select_table(PgSelectData *sd)
{
  char *pghost, *pgport, *pgoptions, *pgtty, *dbName;
  PGconn *conn;
  PGresult *res;
  GString *sql;

  int row, col;

  pghost    = NULL;
  pgport    = NULL;
  pgtty     = NULL;
  pgoptions = NULL;
  dbName    = gtk_entry_get_text((GtkEntry*)sd->pd->cp.entrys[0]);

  if(strlen(dbName) <= 0){
    cd_util_message(ERR_DB);
    return;
  }
  
  conn = PQsetdb(pghost, pgport, pgoptions, pgtty, dbName);

  if(PQstatus(conn) == CONNECTION_BAD){
    cd_util_message(ERR_CON);
    PQfinish(conn);
    return;
  }

  res = PQexec(conn, "BEGIN");

  if(PQresultStatus(res) != PGRES_COMMAND_OK){
    cd_util_message("BEGIN command failed");
    PQclear(res);
    PQfinish(conn);
    return;
  }

  PQclear(res);
  
  sql = g_string_new("DECLARE myportal CURSOR FOR select * from ");
  sql = g_string_append(sql, sd->pd->ni->name);

  res = PQexec(conn, sql->str);

  if(PQresultStatus(res) != PGRES_COMMAND_OK){
    cd_util_message("DECLARE CURSOR command failed");
    PQclear(res);
    g_string_free(sql, TRUE);
    PQfinish(conn);
    return;
  }

  PQclear(res);

  res = PQexec(conn, "FETCH ALL in myportal");

  if(PQresultStatus(res) != PGRES_TUPLES_OK){
    cd_util_message("FETCH ALL command didn't return tuples properly");
    PQclear(res);
    g_string_free(sql, TRUE);
    PQfinish(conn);
    return;
  }

  row = PQntuples(res);
  col = PQnfields(res);

  {
    int i, j;
    gchar *values[row][col];

    for(i=0; i<row; i++){
      for(j=0; j<col; j++)
	values[i][j] =  PQgetvalue(res, i, j);
      gtk_clist_append( (GtkCList *)sd->clist, values[i]);
    }
  }

  PQclear(res);

  res = PQexec(conn, "CLOSE myportal");
  PQclear(res);

  res = PQexec(conn, "END");
  PQclear(res);

  g_string_free(sql, TRUE);
  PQfinish(conn);
}

/*
 * cd_pg_util_insert_tuple
 */
void cd_pg_util_insert_tuple(PgInsertData *id)
{
  int i, j, attr_len;
  PgAttribute *attr;
  GString *sql;
  
  char *pghost, *pgport, *pgoptions, *pgtty, *dbName;
  PGconn *conn;
  PGresult *res;

  int k, entry_num;
  entry_num = g_list_length(id->list);

  if(entry_num <= 0){
    cd_util_message(ERR_TABLE);
    return;
  }

  sql = g_string_new("insert into ");
  sql = g_string_append(sql, id->pd->ni->name);
  sql = g_string_append(sql, " values ( ");

  {
    GtkWidget *entry[entry_num];
    gchar *entry_value[entry_num];

    for(k=0; k<entry_num; k++){
      entry[k] = g_list_nth_data(id->list, k);
      entry_value[k] = gtk_entry_get_text((GtkEntry*)entry[k]);
      if(strlen(entry_value[k]) == 0) {
	cd_util_message(ERR_ENTRY);
	return;
      }
    }

    for(j=0; j<entry_num; j++){
      attr = g_list_nth_data(id->pd->ni->attributes, j);
      switch(attr->type){
      case pg_text:
      case pg_varchar:
      case pg_datetime:
      case pg_date:
      case pg_time:
	sql = g_string_append(sql, "'");
	sql = g_string_append(sql, entry_value[j]);
	sql = g_string_append(sql, "'");
	break;
      case pg_int4:
      case pg_int8:
      case pg_serial:
	sql = g_string_append(sql, entry_value[j]);
	break;
      }
      if(j < entry_num-1)
	sql = g_string_append(sql, ", ");
    }
    sql = g_string_append(sql, ")");
  }

  dbName = gtk_entry_get_text((GtkEntry*)id->pd->cp.entrys[0]);

  if(strlen(dbName) <= 0){
    cd_util_message(ERR_DB);
    return;
  }

  pghost = NULL;
  pgport = NULL;
  pgtty = NULL;
  pgoptions = NULL;
  
  conn = PQsetdb(pghost, pgport, pgoptions, pgtty, dbName);
    
  if(PQstatus(conn) == CONNECTION_BAD){
    cd_util_message(ERR_CON);
    PQfinish(conn);
    g_string_free(sql, TRUE);
    return;
  }

  res = PQexec(conn, "BEGIN");
  if(PQresultStatus(res) != PGRES_COMMAND_OK){
    cd_util_message("BEGIN command failed");
    PQclear(res);
    g_string_free(sql, TRUE);

    PQfinish(conn);
    return;
  }
  PQclear(res);

  res = PQexec(conn, sql->str);
  if(PQresultStatus(res) != PGRES_COMMAND_OK){
    cd_util_message(ERR_SQL);
    PQclear(res);
    g_string_free(sql, TRUE);

    PQfinish(conn);
    return;
  }
  PQclear(res);

  res = PQexec(conn, "COMMIT");
  PQclear(res);

  PQfinish(conn);
  g_string_free(sql, TRUE);
}

/*
 * cd_pg_util_export_db
 */
void cd_pg_util_export_db(PgDialog *pd)
{
  char *pghost, *pgport, *pgoptions, *pgtty, *dbName;
  char sql[64];
  PGconn *conn;
  PGresult *res;

  dbName = gtk_entry_get_text((GtkEntry*)pd->cp.entrys[0]);

  if(strlen(dbName) <= 0){
    cd_util_message(ERR_DB);
    return;
  }

  sprintf(sql, "grant all on %s to public", pd->ni->name);

  pghost = NULL;
  pgport = NULL;
  pgtty = NULL;
  pgoptions = NULL;
  
  conn = PQsetdb(pghost, pgport, pgoptions, pgtty, dbName);
  
  if(PQstatus(conn) == CONNECTION_BAD){
    cd_util_message(ERR_CON);
    PQfinish(conn);
    return;
  }

  res = PQexec(conn, sql);
  if(PQresultStatus(res) != PGRES_COMMAND_OK){
    cd_util_message(ERR_SQL);
    PQclear(res);
    PQfinish(conn);
    return;
  }
  PQclear(res);

  PQfinish(conn);
}
