/*
 * php_class.h
 */
#ifndef PHP_CLASS_H
#define PHP_CLASS_H

#define PHP_CLASS_INIT \
"
<body bgcolor=#ffffff>

<?

class %s {
  var $table;
  var $host;
  var $db;
  var $conn;
  var $res;

  function %s () {
    $this->table = \"%s\";
    $this->host  = \"localhost\";
    $this->db    = \"%s\";
  }

  function connect() {
    $this->conn = pg_connect($this->host, \"5432\", \"\", \"\", $this->db);
    if(!$this->conn) {
      print \"connect error\";
      exit;
    }
    return $conn;
  }

  function exec($sql) {
    $this->res = pg_Exec($this->conn, $sql);
    if(!$this->res){
      print \"Exec error ... $sql ...\";
      exit;
    }
  }

  function close() {
    pg_freeresult($this->res);
    pg_close($this->conn);
  }

  function print_result($str, $values, $names) {
    print \"<center>\\n\";
    print \"<b>$str <font color=blue>$this->table</font></b>\";
    print \"<table>\\n\";
    $i = 0;
    while($values[$i]){
      print \"<tr><td>$names[$i]</td><td>$values[$i]</td></tr>\\n\";
      $i++;
    }
    print \"</table></center>\\n\";
  }
"

#define PHP_CLASS_SELECT1 \
"
  function select() {
    $sql = \"select * from $this->table\";

    $this->connect();
    $this->exec($sql);

    $fields = pg_numfields($this->res);
    $tuples = pg_numrows($this->res);

    print \"<hr><center><strong>\";
    print \"<font color=blue>$this->table</font> Simple Query<br>\";
    print \"</strong><hr>\";
    print \"<table border><tr>\\n\";

    $j=0;
    while($j<$fields) {
      $value = pg_fieldname($this->res, $j);
      print \"<th> $value </th>\\n\";
      $j++;
    }
    print \"</tr>\\n\";
    $j=0;
    while($j<$tuples) {
      $data = pg_fetch_object($this->res, $j);
      print \"<tr>\";
"

#define PHP_CLASS_SELECT2 \
"      print \"<td>\".$data->%s.\"</td>\";\n"

#define PHP_CLASS_SELECT3 \
"
      print \"</tr>\\n\";
      $j++;
    }
    print \"</table>\\n\";
    $this->close();
  }
"
#define PHP_CLASS_INSERT \
"
  function insert_field($val, $type){
    switch($type){
    case \"text\":
    case \"varchar\":
    case \"timestamp\":
    case \"date\":
    case \"time\":
      return \"'$val'\";
    case \"int4\":
    case \"int8\":
      return $val;
    }
  }

  function insert($values, $types, $names){
    $sql = \"insert into $this->table values (\";
    $i = 0;
    $last = sizeof($values)-1;
    while($values[$i]){
      if($last > $i) 
	$sql .= $this->insert_field($values[$i], $types[$i]).\", \";
      else
	$sql .= $this->insert_field($values[$i], $types[$i]).\") \";
      $i++;
    }
    $this->connect();
    $this->exec($sql);

    $this->print_result(\"Inserted a record into\", $values, $names);
  }

  function form($action, $operation) {
    $sql = \"select * from $this->table\";
    $this->connect();
    $this->exec($sql);

    $fields = pg_numfields($this->res);
    $tuples = pg_numrows($this->res);

    print \"<hr><center><strong>\";
    print \"<font color=red>$operation</font>\";
    print \" Form for <font color=blue>$this->table</font><br>\";
    print \"</strong><hr>\";

    print \"<form action=\\\"$action\\\" method=\\\"post\\\">\\n\";
    print \"<table border><tr>\\n\";
    $i=0;
    while($i<$fields) {
      $name = pg_fieldname($this->res, $i);
      $type = pg_fieldtype($this->res, $i);
      print \"</tr><td> $name </td>\";
      print \"<td> <input type=\\\"text\\\" name=\\\"values[$i]\\\"></td>\\n\";
      print \"<input type=\\\"hidden\\\" name=\\\"types[$i]\\\" value=$type></tr>\\n\";
      print \"<input type=\\\"hidden\\\" name=\\\"names[$i]\\\" value=$name></tr>\\n\";
      $i++;
    }
    print \"</tr>\\n\";
    print \"</table>\\n\";
    print \"<table bgcolor=white><tr>\\n\";
    print \"<tr>\";
    print \"<td><input type=submit name=submit value=Sumbit></td>\";
    print \"<td><input type=reset></td>\";
    print \"</tr>\\n\";
    print \"</table>\\n\";
    print \"</form>\\n\";
  }
"

#define PHP_CLASS_DELETE \
"
  function delete_field($value, $type, $name){
    switch($type){
    case \"text\":
    case \"varchar\":
    case \"timestamp\":
    case \"date\":
    case \"time\":
      return \"$name = '$value'\";
    case \"int4\":
    case \"int8\":
      return \"$name = $value\";
    }
  }    

  function delete($values, $types, $names){
    $sql = \"delete from $this->table where \";
    $i = 0;
    $last = sizeof($values)-1;
    while($values[$i]){
      if($last > $i) 
	$sql .= $this->delete_field($values[$i], $types[$i], $names[$i]).\" and \";
      else
	$sql .= $this->delete_field($values[$i], $types[$i], $names[$i]).\" \";

      $i++;
    }
    $this->connect();
    $this->exec($sql);

    $num = pg_cmdtuples($this->res);

    if($num < 2)
      $str = \"Deleted $num record from\";
    else
      $str = \"Deleted $num records from\";

    $this->print_result($str, $values, $names);
  }
"

#define PHP_CLASS_UPDATE1 \
"
  function select_for_update() {
    $sql = \"select * from $this->table\";

    $this->connect();
    $this->exec($sql);

    $fields = pg_numfields($this->res);
    $tuples = pg_numrows($this->res);

    print \"<hr><center><strong>\";
    print \"<font color=blue>$this->table</font> Query for Update<br>\";
    print \"</strong><hr>\";
    print \"<table border><tr>\\n\";

    $j=0;
    while($j<$fields) {
      $value = pg_FieldName($this->res, $j);
      print \"<th> $value </th>\\n\";
      $j++;
    }
    print \"</tr>\\n\";
    $j=0;
    while($j<$tuples) {
      $data = pg_fetch_object($this->res, $j);
      print \"<tr>\";
"

#define PHP_CLASS_UPDATE2_NORMAL \
"      print \"<td>\".$data->%s.\"</td>\";\n"

#define PHP_CLASS_UPDATE2_SERIAL \
"      print \"<td><a href =\\\"update.php3/?%d&%s&$data->%s\\\">\".$data->%s.\"</a></td>\";\n"

#define PHP_CLASS_UPDATE3 \
"
      print \"</tr>\\n\";
      $j++;
    }
    print \"</table>\\n\";
    $this->close();
  }

  function update_form($action, $query_string) {
    list($key_index, $key_field, $key) = split(\"&\", $query_string);
    $sql = \"select * from $this->table where $key_field = $key\";

    $this->connect();
    $this->exec($sql);

    $fields = pg_numfields($this->res);
    $tuples = pg_numrows($this->res);

    print \"<hr><center><strong>\";
    print \"<font color=red>Update</font>\";
    print \" Form for <font color=blue>$this->table</font><br>\";
    print \"</strong><hr>\";

    print \"<form action=\\\"$action\\\" method=\\\"post\\\">\\n\";
    print \"<table>\\n\";
    print \"<table border><tr>\\n\";
    $i=0;
    while($i<$fields) {
      $name = pg_fieldname($this->res, $i);
      $type = pg_fieldtype($this->res, $i);
      $value = pg_result($this->res, 0, $i);
      print \"</tr><td> $name </td>\";
      if($i == $key_index)
	print \"<td> <input type=\\\"hidden\\\" name=\\\"values[$i]\\\" value=$value>$value</td>\\n\";
      else
	print \"<td> <input type=\\\"text\\\" name=\\\"values[$i]\\\" value=$value></td>\\n\";
      print \"<input type=\\\"hidden\\\" name=\\\"types[$i]\\\" value=$type></tr>\\n\";
      print \"<input type=\\\"hidden\\\" name=\\\"names[$i]\\\" value=$name></tr>\\n\";
      $i++;
    }
    print \"<input type=\\\"hidden\\\" name=\\\"key_index\\\" value=$key_index></tr>\\n\";
    print \"</tr>\\n\";
    print \"</table>\\n\";
    print \"<table bgcolor=white><tr>\\n\";
    print \"<tr>\";
    print \"<td><input type=submit name=submit value=Sumbit></td>\";
    print \"<td><input type=reset></td>\";
    print \"</tr>\\n\";
    print \"</table>\\n\";
    print \"</form>\\n\";
  }

  function update_field($value, $type, $name){
    switch($type){
    case \"text\":
    case \"varchar\":
    case \"timestamp\":
    case \"date\":
    case \"time\":
      return \"$name = '$value'\";
    case \"int4\":
    case \"int8\":
      return \"$name = $value\";
    }
  }    

  function update($values, $types, $names, $key_index) {
    $sql = \"update $this->table set \";
    $i = 0;
    $last = sizeof($values)-1;

    if($key_index == $last)
      $last--;

    while($values[$i]){
      if($i == $key_index)
	;
      else if($i < $last)
	$sql .= $this->update_field($values[$i], $types[$i], $names[$i]).\", \";
      else
	$sql .= $this->update_field($values[$i], $types[$i], $names[$i]);
      $i++;
    }
    $sql .= \" where  $names[$key_index] = $values[$key_index]\";

    $this->connect();
    $this->exec($sql);

    $this->print_result(\"Updated record\", $values, $names); 
  }
"
#define PHP_CLASS_TERM \
"
}

?>

</body></html>
"

#endif
