(in-package :unf)

(declaim (inline hangul-syllable-char-p))

(defconstant +SYLLABLE-BEGIN+ #xAC00)
(defconstant +SYLLABLE-LAST+ (1- (+ #xAC00 (* 19 21 28))))

(defun hangul-syllable-char-p (ch &aux (cd (char-code ch)))
  (<= +SYLLABLE-BEGIN+ cd +SYLLABLE-LAST+))

(let* ((s-base #xAC00)
       (l-base #x1100)
       (v-base #x1161)
       (t-base #x11A7)
       (l-count 19)
       (v-count 21)
       (t-count 28)
       (n-count (* v-count t-count))
       (s-count (* l-count n-count)))

  (defun decompose-hangul (sb ch &aux (cd (char-code ch)))
    (declare #.*fastest*
             (string-builder sb))
    (let ((s-index (- cd s-base)))
      (let ((lc (+ l-base (floor s-index n-count)))
            (vc (+ v-base (floor (mod s-index n-count) t-count)))
            (tc (+ t-base (mod s-index t-count))))
        (string-builder-add sb (code-char lc))
        (string-builder-add sb (code-char vc))
        (when (/= tc t-base)
          (string-builder-add sb (code-char tc))))))
  
  (defun compose-hangul (ch1 ch2 &aux (cd1 (char-code ch1)))
    (declare #.*fastest*)
    (let ((l-index (- cd1 l-base))
          (s-index (- cd1 s-base)))
      (cond ((<= 0 l-index (1- l-count))
             (let ((v-index (- (char-code ch2) v-base)))
               (and (<= 0 v-index (1- v-count))
                    (code-char 
                     (with-fixnum
                      (+ s-base (* (+ (* l-index v-count) v-index) t-count)))))))
            
            ((and (<= 0 s-index (1- s-count))
                  (zerop (mod s-index t-count)))
             (let ((t-index (- (char-code ch2) t-base)))
               (and (< 0 t-index t-count)
                    (code-char (+ cd1 t-index)))))))))


