(in-package :unf)

(declaim (inline substr))

(defmacro define-constant (name value &optional doc)
  `(defconstant ,name (if (boundp ',name) (symbol-value ',name) ,value)
     ,@(when doc (list doc))))

(defun substr (str start end)
  (if (and (= start 0)
           (= end (length str)))
      str
    (subseq str start end)))

(defmacro a.if (exp then else)
  `(let ((it ,exp))
     (if it
         ,then
       ,else)))

(defmacro with-fixnum (exp)
  `(the fixnum ,(mapcar 
                 (lambda (e)
                   (if (atom e)
                       e
                     `(with-fixnum ,e)))
                 exp)))