<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable
 *              to obtain it through the world-wide-web, please send a note to
 *              license@php.net so we can mail you a copy immediately.
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/04/14] Ver1.0.1Nighty package
 * ========================================================================
 */

/*
 * @param  string $string
 * @return string
 */
function smarty_modifier_t_cmdkmaps($string)
{
    if (!OPENPNE_USE_CMD_TAG) {
        return $string;
    }
    $regexp = '/&lt;cmd\s+src="gmaps"\s+args="([\w\-\+%]+(,[\w\-\+%]+)*)"\s*&gt;/i';
    return preg_replace_callback($regexp, '_smarty_modifier_t_cmdkmaps_make_js', $string);
}

function _smarty_modifier_t_cmdkmaps_make_js($matches)
{
    $args = $matches[1];

    $_args = explode(',', $args);

    $zoom = 300*pow(2,17-$_args[0]);
    if($zoom == 600) $zoom = 690;
    if($zoom == 153600) $zoom = 230230;
    $lat = substr($_args[1].$_args[2].'0',0,8);
    $lon = substr($_args[3].$_args[4].'0',0,9);

    $result = <<<EOD
マップ:[<a href="gmaps/kmaps.php?{$lat}&amp;{$lon}&amp;{$zoom}">見る</a>]
EOD;
    return $result;
}

?>
