﻿using System.Runtime.Serialization.Json;
using System.Text;
using System.Xml;
using System.Xml.Linq;
using LinqToTwitter;

namespace Azyobuzi.UserStreamEx
{
    /// <summary>
    /// LINQ to Twitterへの拡張
    /// </summary>
    public static class AddToLinqToTwitter
    {
        /// <summary>
        /// <see cref="LinqToTwitter.TwitterContext"/>から<see cref="Azyobuzi.UserStreamEx.UserStream"/>のインスタンスを作成します。
        /// </summary>
        /// <param name="twCtx">認証済みの<see cref="LinqToTwitter.TwitterContext"/></param>
        public static INotStartedUserStream UserStreamEx(this TwitterContext twCtx)
        {
            return new UserStream(twCtx.AuthorizedClient);
        }
    }

    internal static class MyExtensions
    {
        internal static XElement JsonToXml(this string json)
        {
            using (var reader = JsonReaderWriterFactory.CreateJsonReader(Encoding.UTF8.GetBytes(json), XmlDictionaryReaderQuotas.Max))
            {
                return XElement.Load(reader);
            }
        }
    }
}
