/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;

public class Cws2Fws {
    private static final String CWS = "CWS";
    private static final String FWS = "FWS";
    private static final String TMP_FWS = "fws_tmp.swf";

    public static boolean isCws(File file) {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            byte[] header = new byte[CWS.length()];
            bis.read(header, 0, header.length);
            if (CWS.equals(new String(header))) {
                return true;
            }
        }
        catch (IOException ex) {
            Cws2Fws.log("Cws2Fws:" + ex.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    Cws2Fws.log("Cws2Fws:" + ex.getMessage());
                }
            }
        }
        return false;
    }

    public static File createFws(File in) {
        boolean wasCws = false;
        if (!Cws2Fws.isCws(in)) {
            return null;
        }
        File out = new File(TMP_FWS);
        InputStream is = null;
        InputStream iis = null;
        OutputStream os = null;
        try {
            int rs;
            int headerSize = 8;
            byte[] header = new byte[8];
            is = new FileInputStream(in);
            int size = 0;
            while (size < 8) {
                int read = is.read(header, size, 8);
                if (read < 0) {
                    throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u4e0d\u6b63");
                }
                size += read;
            }
            if (new String(header, 0, CWS.length()).equals(CWS)) {
                wasCws = true;
            }
            header[0] = "F".getBytes()[0];
            os = new BufferedOutputStream(new FileOutputStream(out));
            os.write(header);
            byte[] buffer = new byte[0x100000];
            iis = wasCws ? new InflaterInputStream(is) : is;
            while ((rs = iis.read(buffer)) >= 0) {
                os.write(buffer, 0, rs);
            }
            File file = out;
            return file;
        }
        catch (IOException ex) {
            Cws2Fws.log("Cws2Fws:" + ex.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Cws2Fws.log("Cws2Fws:" + ex.getMessage());
                }
            }
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException ex) {
                    Cws2Fws.log("Cws2Fws:" + ex.getMessage());
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Cws2Fws.log("Cws2Fws:" + ex.getMessage());
                }
            }
        }
        return null;
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    public static boolean isFws(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] header = new byte[FWS.length()];
            fis.read(header, 0, header.length);
            if (FWS.equals(new String(header))) {
                return true;
            }
        }
        catch (IOException ex) {
            Cws2Fws.log("Cws2Fws:" + ex.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Cws2Fws.log("Cws2Fws:" + ex.getMessage());
                }
            }
        }
        return false;
    }
}

